/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.HtmlExportUtil;
import com.jaspersoft.jasperserver.remote.exporters.AbstractExporter;
import com.jaspersoft.jasperserver.war.util.JRHtmlExportUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="remoteHtmlExporter")
@Scope(value="prototype")
public class HtmlExporter
extends AbstractExporter {
    public static final String CONTEXT_PATH_PARAM_NAME = "contextPath";
    @Resource
    private List<String> htmlReportHeaderIncludes;

    @Override
    public JRExporter createExporter() throws Exception {
        return HtmlExportUtil.getHtmlExporter((JasperReportsContext)this.getJasperReportsContext());
    }

    @Override
    public void configureExporter(JRExporter exporter, HashMap exportParameters) throws Exception {
        StringBuilder htmlHeader = new StringBuilder();
        final String contextPath = exportParameters.get(CONTEXT_PATH_PARAM_NAME) != null ? exportParameters.get(CONTEXT_PATH_PARAM_NAME) : "";
        for (String currentInclude : this.htmlReportHeaderIncludes) {
            htmlHeader.append(currentInclude.replaceAll("\\{contextPath\\}", contextPath));
        }
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)htmlHeader.toString());
        HttpServletRequest proxy = (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String result = null;
                if ("getContextPath".equals(method.getName())) {
                    result = contextPath;
                }
                return result;
            }
        });
        exporter.setParameter((JRExporterParameter)JRHtmlExportUtils.PARAMETER_HTTP_REQUEST, (Object)proxy);
        if (exportParameters.get(JRExporterParameter.IGNORE_PAGE_MARGINS) != null) {
            exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, exportParameters.get(JRExporterParameter.IGNORE_PAGE_MARGINS));
        }
        if (exportParameters.get("IMAGES_URI") != null) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)("" + exportParameters.get("IMAGES_URI")));
        } else {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"images/");
        }
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, new LinkedHashMap());
    }

    @Override
    public String getContentType() {
        return "text/html";
    }
}

