/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.remote.ReportExporter;
import com.jaspersoft.jasperserver.remote.services.ReportOutputPages;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;

public abstract class AbstractExporter
implements ReportExporter {
    @Resource(name="jasperReportsRemoteContext")
    private JasperReportsContext jasperReportsContext;

    @Override
    public Map<JRExporterParameter, Object> exportReport(JasperPrint jasperPrint, OutputStream output, EngineService engineService, HashMap exportParameters, ExecutionContext executionContext, String reportUnitURI) throws Exception {
        JRExporter exporter = this.createExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        if (exportParameters.get("PAGE") != null) {
            int pageIndex = Integer.parseInt((String)exportParameters.get("PAGE"));
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)(--pageIndex));
        } else if (exportParameters.get("OUTPUT_PAGES") != null) {
            ReportOutputPages pages = (ReportOutputPages)exportParameters.get("OUTPUT_PAGES");
            if (pages.getPage() != null) {
                exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)(pages.getPage() - 1));
            } else if (pages.getStartPage() != null && pages.getEndPage() != null) {
                exporter.setParameter(JRExporterParameter.START_PAGE_INDEX, (Object)(pages.getStartPage() - 1));
                exporter.setParameter(JRExporterParameter.END_PAGE_INDEX, (Object)(pages.getEndPage() - 1));
            }
        }
        this.configureExporter(exporter, exportParameters);
        exporter.exportReport();
        return exporter.getParameters();
    }

    public abstract JRExporter createExporter() throws Exception;

    public void configureExporter(JRExporter exporter, HashMap exportParameters) throws Exception {
    }

    protected Object getSingleParameterValue(String parameterName, Map<String, Object> exportParameters) {
        Object result = null;
        if (exportParameters.get(parameterName) != null) {
            if (exportParameters.get(parameterName) instanceof String[]) {
                if (((String[])exportParameters.get(parameterName)).length > 0) {
                    result = ((String[])exportParameters.get(parameterName))[0];
                }
            } else {
                result = exportParameters.get(parameterName);
            }
        }
        return result;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }
}

