/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exception.builders;

import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class LocalizedErrorDescriptorBuilder
extends ErrorDescriptor.Builder {
    public static final String BUNDLE_PREFIX = "exception.remote.";
    private MessageSource messageSource;

    public LocalizedErrorDescriptorBuilder(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public ErrorDescriptor createDescriptor(String errorCode, Object ... params) {
        Locale locale = LocaleContextHolder.getLocale();
        String message = this.messageSource != null ? this.messageSource.getMessage(errorCode, params, null, locale) : errorCode;
        return this.setMessage(message).setErrorCode(errorCode).setParameters(params).getErrorDescriptor();
    }

    public ErrorDescriptor localizeDescriptor(ErrorDescriptor base) {
        Locale locale = LocaleContextHolder.getLocale();
        String message = base.getMessage();
        if (this.messageSource != null) {
            message = this.messageSource.getMessage(BUNDLE_PREFIX + base.getErrorCode(), (Object[])base.getParameters(), message, locale);
        }
        base.setMessage(message);
        return base;
    }
}

