/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.XMLException;
import nu.xom.xslt.XOMResult;
import nu.xom.xslt.XOMSource;
import nu.xom.xslt.XSLException;
import org.xml.sax.SAXParseException;

public final class XSLTransform {
    private Templates templates;
    private NodeFactory factory;
    private Map parameters = new HashMap();
    private static ErrorListener errorsAreFatal = new FatalListener();

    private XSLTransform(Source source) throws XSLException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setErrorListener(errorsAreFatal);
            this.templates = factory.newTemplates(source);
        }
        catch (TransformerFactoryConfigurationError error) {
            throw new XSLException("Could not locate a TrAX TransformerFactory", error);
        }
        catch (TransformerConfigurationException ex) {
            throw new XSLException("Syntax error in stylesheet", ex);
        }
    }

    public XSLTransform(Document stylesheet) throws XSLException {
        this(stylesheet, null);
    }

    public XSLTransform(Document stylesheet, NodeFactory factory) throws XSLException {
        this(stylesheet, factory, null);
    }

    public XSLTransform(Document stylesheet, NodeFactory factory, TransformerFactory transformerFactory) throws XSLException {
        if (factory == null) {
            factory = new NodeFactory();
        }
        this.factory = factory;
        if (transformerFactory == null) {
            try {
                transformerFactory = TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError error) {
                throw new XSLException("Could not locate a TrAX TransformerFactory", error);
            }
        }
        try {
            this.templates = transformerFactory.newTemplates(new XOMSource(stylesheet));
        }
        catch (TransformerConfigurationException ex) {
            throw new XSLException("Syntax error in stylesheet", ex);
        }
    }

    public Nodes transform(Document in) throws XSLException {
        return this.transform(new XOMSource(in));
    }

    public void setParameter(String name, Object value) {
        this.setParameter(name, null, value);
    }

    public void setParameter(String name, String namespace, Object value) {
        if (namespace == null || "".equals(namespace)) {
            this._setParameter(name, value);
        } else {
            this._setParameter("{" + namespace + "}" + name, value);
        }
    }

    private void _setParameter(String name, Object value) {
        if (value == null) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    public Nodes transform(Nodes in) throws XSLException {
        if (in.size() == 0) {
            return new Nodes();
        }
        XOMSource source = new XOMSource(in);
        return this.transform(source);
    }

    private Nodes transform(Source in) throws XSLException {
        try {
            XOMResult out = new XOMResult(this.factory);
            Transformer transformer = this.templates.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setErrorListener(errorsAreFatal);
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = this.parameters.get(key);
                transformer.setParameter(key, value);
            }
            transformer.transform(in, out);
            return out.getResult();
        }
        catch (Exception ex) {
            TransformerException tex;
            Throwable nested;
            Throwable cause = ex;
            if (cause instanceof TransformerException && (nested = (tex = (TransformerException)cause).getException()) != null && (cause = nested) instanceof SAXParseException && (nested = ((SAXParseException)cause).getException()) != null) {
                cause = nested;
            }
            throw new XSLException(ex.getMessage(), cause);
        }
    }

    public static Document toDocument(Nodes nodes) {
        Element root = null;
        int rootPosition = 0;
        int i = 0;
        while (i < nodes.size()) {
            if (nodes.get(i) instanceof Element) {
                rootPosition = i;
                root = (Element)nodes.get(i);
                break;
            }
            ++i;
        }
        if (root == null) {
            throw new XMLException("No root element");
        }
        Document result = new Document(root);
        int i2 = 0;
        while (i2 < rootPosition) {
            result.insertChild(nodes.get(i2), i2);
            ++i2;
        }
        i2 = rootPosition + 1;
        while (i2 < nodes.size()) {
            result.appendChild(nodes.get(i2));
            ++i2;
        }
        return result;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.templates + "]";
    }

    private static class FatalListener
    implements ErrorListener {
        private FatalListener() {
        }

        public void warning(TransformerException exception) {
        }

        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

