/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMConverter {
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private DOMConverter() {
    }

    public static Document convert(org.w3c.dom.Document domDocument) {
        return DOMConverter.convert(domDocument, new NodeFactory());
    }

    public static Document convert(org.w3c.dom.Document domDocument, NodeFactory factory) {
        org.w3c.dom.Element domRoot = domDocument.getDocumentElement();
        Element xomRoot = factory.makeRootElement(domRoot.getTagName(), domRoot.getNamespaceURI());
        Document xomDocument = factory.startMakingDocument();
        xomDocument.setRootElement(xomRoot);
        Nodes result = DOMConverter.convert(domRoot, factory);
        boolean beforeRoot = true;
        int p = 0;
        int i = 0;
        while (i < result.size()) {
            Node n = result.get(i);
            if (beforeRoot) {
                if (n instanceof Element) {
                    xomDocument.setRootElement((Element)n);
                    beforeRoot = false;
                } else {
                    xomDocument.insertChild(n, p++);
                }
            } else {
                xomDocument.appendChild(n);
            }
            ++i;
        }
        org.w3c.dom.Node current = domDocument.getFirstChild();
        int position = 0;
        while (current.getNodeType() != 1) {
            Nodes nodes = DOMConverter.convert(current, factory);
            int i2 = 0;
            while (i2 < nodes.size()) {
                xomDocument.insertChild(nodes.get(i2), position++);
                ++i2;
            }
            current = current.getNextSibling();
        }
        current = current.getNextSibling();
        while (current != null) {
            Nodes nodes = DOMConverter.convert(current, factory);
            int i3 = 0;
            while (i3 < nodes.size()) {
                xomDocument.appendChild(nodes.get(i3));
                ++i3;
            }
            current = current.getNextSibling();
        }
        return xomDocument;
    }

    public static Nodes convert(DocumentFragment fragment) {
        return DOMConverter.convert(fragment, new NodeFactory());
    }

    public static Nodes convert(DocumentFragment fragment, NodeFactory factory) {
        Nodes result = new Nodes();
        NodeList children = fragment.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Nodes nodes = DOMConverter.convert(children.item(i), factory);
            DOMConverter.appendNodes(result, nodes);
            ++i;
        }
        return result;
    }

    private static void appendNodes(Nodes parent, Nodes children) {
        int i = 0;
        while (i < children.size()) {
            parent.append(children.get(i));
            ++i;
        }
    }

    private static Nodes convert(org.w3c.dom.Node node, NodeFactory factory) {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                return DOMConverter.convert((org.w3c.dom.Element)node, factory);
            }
            case 8: {
                return DOMConverter.convert((org.w3c.dom.Comment)node, factory);
            }
            case 10: {
                return DOMConverter.convert((DocumentType)node, factory);
            }
            case 3: {
                return DOMConverter.convert((org.w3c.dom.Text)node, factory);
            }
            case 4: {
                return DOMConverter.convert((org.w3c.dom.Text)node, factory);
            }
            case 7: {
                return DOMConverter.convert((org.w3c.dom.ProcessingInstruction)node, factory);
            }
        }
        throw new XMLException("Unexpected DOM node type: " + type);
    }

    public static Comment convert(org.w3c.dom.Comment comment) {
        return new Comment(comment.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.Comment comment, NodeFactory factory) {
        return factory.makeComment(comment.getNodeValue());
    }

    public static Text convert(org.w3c.dom.Text text) {
        return new Text(text.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.Text text, NodeFactory factory) {
        return factory.makeText(text.getNodeValue());
    }

    public static Attribute convert(Attr attribute) {
        String name = attribute.getName();
        String uri = attribute.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        return new Attribute(name, uri, attribute.getNodeValue());
    }

    public static ProcessingInstruction convert(org.w3c.dom.ProcessingInstruction pi) {
        return new ProcessingInstruction(pi.getTarget(), pi.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.ProcessingInstruction pi, NodeFactory factory) {
        return factory.makeProcessingInstruction(pi.getTarget(), pi.getNodeValue());
    }

    public static DocType convert(DocumentType doctype) {
        DocType result = new DocType(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
        result.setInternalDTDSubset(doctype.getInternalSubset());
        return result;
    }

    private static Nodes convert(DocumentType doctype, NodeFactory factory) {
        Nodes nodes = factory.makeDocType(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
        int i = 0;
        while (i < nodes.size()) {
            Node node = nodes.get(i);
            if (node instanceof DocType) {
                ((DocType)node).setInternalDTDSubset(doctype.getInternalSubset());
                break;
            }
            ++i;
        }
        return nodes;
    }

    public static Element convert(org.w3c.dom.Element element) {
        return (Element)DOMConverter.convert(element, new NodeFactory()).get(0);
    }

    /*
     * Unable to fully structure code
     */
    private static Nodes convert(org.w3c.dom.Element element, NodeFactory factory) {
        current = element;
        result = DOMConverter.makeElement(element, factory);
        if (result == null) {
            out = new Nodes();
            children = element.getChildNodes();
            i = 0;
            while (i < children.getLength()) {
                temp = DOMConverter.convert(children.item(i), factory);
                j = 0;
                while (j < temp.size()) {
                    out.append(temp.get(j));
                    ++j;
                }
                ++i;
            }
            return out;
        }
        parent = result;
        backtracking = false;
        block2: while (true) {
            if (current.hasChildNodes() && !backtracking) {
                current = current.getFirstChild();
                backtracking = false;
            } else {
                if (current == element) break;
                if (current.getNextSibling() != null) {
                    current = current.getNextSibling();
                    backtracking = false;
                } else {
                    current = current.getParentNode();
                    backtracking = true;
                    if (parent.getParent() == null) continue;
                    parent = parent.getParent();
                    continue;
                }
            }
            type = current.getNodeType();
            if (type == 1) {
                child = DOMConverter.makeElement((org.w3c.dom.Element)current, factory);
                if (child == null) continue;
                parent.appendChild(child);
                if (!current.hasChildNodes()) continue;
                parent = child;
                continue;
            }
            children = DOMConverter.convert(current, factory);
            i = 0;
            while (true) {
                if (i < children.size()) ** break;
                continue block2;
                parent.appendChild(children.get(i));
                ++i;
            }
            break;
        }
        return factory.finishMakingElement(result);
    }

    private static Element makeElement(org.w3c.dom.Element element, NodeFactory factory) {
        String namespaceURI = element.getNamespaceURI();
        String tagName = element.getTagName();
        Element result = element.getParentNode() == null || element.getParentNode().getNodeType() == 9 ? factory.makeRootElement(tagName, namespaceURI) : factory.startMakingElement(tagName, namespaceURI);
        if (result == null) {
            return null;
        }
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            String uri = attribute.getNamespaceURI();
            String value = attribute.getValue();
            if (uri == null) {
                uri = "";
            }
            if (uri.equals(XMLNS_NAMESPACE)) {
                String prefix;
                String currentURI;
                if (!name.equals("xmlns") && !value.equals(currentURI = result.getNamespaceURI(prefix = name.substring(name.indexOf(58) + 1)))) {
                    result.addNamespaceDeclaration(prefix, value);
                }
            } else {
                Nodes nodes = factory.makeAttribute(name, uri, value, Attribute.Type.UNDECLARED);
                int j = 0;
                while (j < nodes.size()) {
                    Node child = nodes.get(j);
                    if (child instanceof Attribute) {
                        result.addAttribute((Attribute)child);
                    } else {
                        result.appendChild(child);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static org.w3c.dom.Document convert(Document document, DOMImplementation impl) {
        Element root = document.getRootElement();
        String rootName = root.getQualifiedName();
        String rootNamespace = root.getNamespaceURI();
        DocType doctype = document.getDocType();
        DocumentType domDOCTYPE = null;
        if (doctype != null) {
            domDOCTYPE = impl.createDocumentType(rootName, doctype.getPublicID(), doctype.getSystemID());
        }
        org.w3c.dom.Document domDoc = impl.createDocument(rootNamespace, rootName, domDOCTYPE);
        org.w3c.dom.Element domRoot = domDoc.getDocumentElement();
        boolean beforeRoot = true;
        int i = 0;
        while (i < document.getChildCount()) {
            Node original = document.getChild(i);
            if (!(original instanceof DocType)) {
                if (original instanceof Element) {
                    DOMConverter.convert((Element)original, domDoc);
                    beforeRoot = false;
                } else {
                    org.w3c.dom.Node domNode = DOMConverter.convert(original, domDoc);
                    if (beforeRoot) {
                        domDoc.insertBefore(domNode, domRoot);
                    } else {
                        domDoc.appendChild(domNode);
                    }
                }
            }
            ++i;
        }
        return domDoc;
    }

    private static org.w3c.dom.Node convert(Node node, org.w3c.dom.Document document) {
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document);
        }
        if (node instanceof Comment) {
            return DOMConverter.convert((Comment)node, document);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMConverter.convert((ProcessingInstruction)node, document);
        }
        throw new XMLException("Unexpected node type: " + node.getClass().getName());
    }

    private static org.w3c.dom.Comment convert(Comment comment, org.w3c.dom.Document document) {
        return document.createComment(comment.getValue());
    }

    private static org.w3c.dom.Text convert(Text text, org.w3c.dom.Document document) {
        return document.createTextNode(text.getValue());
    }

    private static org.w3c.dom.ProcessingInstruction convert(ProcessingInstruction pi, org.w3c.dom.Document document) {
        return document.createProcessingInstruction(pi.getTarget(), pi.getValue());
    }

    private static org.w3c.dom.Element convert(Element xomElement, org.w3c.dom.Document document) {
        org.w3c.dom.Element domResult = DOMConverter.makeElement(xomElement, document);
        org.w3c.dom.Node domParent = domResult;
        Node xomCurrent = xomElement;
        int index = 0;
        int[] indexes = new int[10];
        int top = 0;
        indexes[0] = 0;
        boolean end = false;
        while (true) {
            if (!end && xomCurrent.getChildCount() > 0) {
                xomCurrent = xomCurrent.getChild(0);
                index = 0;
                indexes = DOMConverter.grow(indexes, ++top);
                indexes[top] = 0;
            } else {
                end = false;
                ParentNode xomParent = xomCurrent.getParent();
                org.w3c.dom.Node grandparent = domParent.getParentNode();
                if (grandparent.getNodeType() == 1 && xomCurrent instanceof Element) {
                    domParent = grandparent;
                }
                if (xomParent.getChildCount() - 1 == index) {
                    ParentNode tp;
                    xomCurrent = xomParent;
                    --top;
                    if (xomCurrent == xomElement || (tp = xomCurrent.getParent()) == null) break;
                    index = indexes[top];
                    end = true;
                    continue;
                }
                indexes[top] = ++index;
                xomCurrent = xomParent.getChild(index);
            }
            if (xomCurrent instanceof Element) {
                Node currentElement = xomCurrent;
                org.w3c.dom.Element child = DOMConverter.makeElement((Element)currentElement, document);
                domParent.appendChild(child);
                domParent = child;
                continue;
            }
            org.w3c.dom.Node child = DOMConverter.convert(xomCurrent, document);
            domParent.appendChild(child);
        }
        return domResult;
    }

    private static int[] grow(int[] indexes, int top) {
        if (top < indexes.length) {
            return indexes;
        }
        int[] result = new int[indexes.length * 2];
        System.arraycopy(indexes, 0, result, 0, indexes.length);
        return result;
    }

    private static org.w3c.dom.Element makeElement(Element element, org.w3c.dom.Document document) {
        String namespace = element.getNamespaceURI();
        org.w3c.dom.Element result = element.getParent() instanceof Document ? document.getDocumentElement() : (namespace.equals("") ? document.createElement(element.getQualifiedName()) : document.createElementNS(namespace, element.getQualifiedName()));
        int attributeCount = element.getAttributeCount();
        int i = 0;
        while (i < attributeCount) {
            Attr attr;
            Attribute attribute = element.getAttribute(i);
            String attns = attribute.getNamespaceURI();
            if (attns.equals("")) {
                attr = document.createAttribute(attribute.getLocalName());
                result.setAttributeNode(attr);
            } else {
                attr = document.createAttributeNS(attns, attribute.getQualifiedName());
                result.setAttributeNodeNS(attr);
            }
            attr.setValue(attribute.getValue());
            ++i;
        }
        int namespaceCount = element.getNamespaceDeclarationCount();
        int i2 = 0;
        while (i2 < namespaceCount) {
            Element parentElement;
            String additionalPrefix = element.getNamespacePrefix(i2);
            String uri = element.getNamespaceURI(additionalPrefix);
            ParentNode parentNode = element.getParent();
            if (!(!(parentNode instanceof Element) ? uri.equals("") : uri.equals((parentElement = (Element)parentNode).getNamespaceURI(additionalPrefix)))) {
                Attr attr;
                if ("".equals(additionalPrefix)) {
                    attr = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns");
                    result.setAttributeNodeNS(attr);
                    attr.setValue(uri);
                } else {
                    attr = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + additionalPrefix);
                    result.setAttributeNodeNS(attr);
                    attr.setValue(uri);
                }
            }
            ++i2;
        }
        return result;
    }
}

