/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Level;

public class XMLA_MemberProp {
    private String caption;
    private Level level;
    private Dimension dimension;
    private String name;
    private String xmlTag;
    private boolean sap = false;
    static final char[] special = new char[]{' ', '<', '>'};

    public XMLA_MemberProp(String name, String caption, Level level) {
        this.name = name;
        this.caption = caption;
        this.level = level;
        this.sap = false;
        this.dimension = level.getHierarchy().getDimension();
        this.xmlTag = this.escapeSpecialChars(name);
    }

    public XMLA_MemberProp(String name, String caption, Dimension dimension) {
        this.name = name;
        this.caption = caption;
        this.level = null;
        this.sap = true;
        this.dimension = dimension;
        this.xmlTag = this.escapeSpecialChars(name);
        int len = this.xmlTag.length();
        if (this.xmlTag.charAt(0) == '[' && this.xmlTag.charAt(len - 1) == ']') {
            this.xmlTag = this.xmlTag.substring(1, len - 1);
        }
        if (this.xmlTag.charAt(0) != '_') {
            this.xmlTag = "_" + this.xmlTag;
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String getXmlTag() {
        return this.xmlTag;
    }

    private String escapeSpecialChars(String str) {
        StringBuffer sb = new StringBuffer();
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (int j = 0; j < special.length; ++j) {
                if (c != special[j]) continue;
                sb.append("_x");
                String x = Integer.toHexString(c);
                int k = 4 - x.length();
                for (int m = 0; m < k; ++m) {
                    sb.append('0');
                }
                sb.append(x);
                sb.append("_");
                continue block0;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String getCaption() {
        return this.caption;
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

