/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.core.util.JSONUtil;
import com.jaspersoft.jasperserver.search.action.SearchHolder;
import com.jaspersoft.jasperserver.search.common.ItemsExistException;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.mode.SearchModeSettingsResolver;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.search.util.JSONConverter;
import com.jaspersoft.jasperserver.war.action.BaseFormAction;
import java.util.Collection;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public class BaseSearchAction
extends BaseFormAction {
    private static final String ATTRIBUTE_SEARCH_HOLDER = "searchHolder";
    public static final String PARAMETER_SOURCE_FOLDER_URI = "sourceFolderUri";
    public static final String PARAMETER_FOLDER = "folder";
    public static final String PARAMETER_SELECTED_RESOURCES = "selectedResources";
    public static final String PARAMETER_IGNORE_DEPENDENT_RESOURCES = "ignoreDependentResources";
    public static final String PARAMETER_DEST_FOLDER_URI = "destFolderUri";
    public static final String PARAMETER_SELECTED_RESOURCE = "selectedResource";
    private static final String PARAMETER_MODE = "mode";
    private static final String PARAMETER_LAST_MODE = "lastMode";
    private SearchModeSettingsResolver searchModeSettingsResolver;
    private ObjectMapper objectMapper = new ObjectMapper();

    public void setSearchModeSettingsResolver(SearchModeSettingsResolver searchModeSettingsResolver) {
        this.searchModeSettingsResolver = searchModeSettingsResolver;
    }

    protected JSONConverter getConverter(RequestContext context) {
        return this.searchModeSettingsResolver.getSettings(this.getMode(context)).getJsonConverter();
    }

    protected RepositorySearchConfiguration getConfiguration(RequestContext context) {
        return this.searchModeSettingsResolver.getSettings(this.getMode(context)).getRepositorySearchConfiguration();
    }

    protected InitialStateResolver getInitialStateResolver(RequestContext context) {
        return this.searchModeSettingsResolver.getSettings(this.getMode(context)).getInitialStateResolver();
    }

    protected String getErrorMessage(Exception e) {
        String errorMsg;
        if (e instanceof ItemsExistException) {
            Collection<String> items = ((ItemsExistException)e).getItems();
            ArrayNode itemsJArr = this.objectMapper.createArrayNode();
            for (String item : items) {
                itemsJArr.add(item);
            }
            ObjectNode msgObject = this.objectMapper.createObjectNode();
            msgObject.put("existingLabels", (JsonNode)itemsJArr);
            return JSONUtil.toJSON((Object)msgObject);
        }
        if (e instanceof JSException) {
            JSException jse = (JSException)e;
            errorMsg = this.messages.getMessage(jse.getMessage(), jse.getArgs(), LocaleContextHolder.getLocale());
        } else {
            errorMsg = e.getMessage();
        }
        return errorMsg;
    }

    protected void initSearchHolder(RequestContext context) {
        SearchHolder searchHolder = this.getSearchHolder(context);
        if (searchHolder == null) {
            searchHolder = new SearchHolder();
            context.getExternalContext().getSessionMap().put(ATTRIBUTE_SEARCH_HOLDER, (Object)searchHolder);
        }
    }

    protected SearchHolder getSearchHolder(RequestContext context) {
        SharedAttributeMap session = context.getExternalContext().getSessionMap();
        return (SearchHolder)session.get(ATTRIBUTE_SEARCH_HOLDER);
    }

    protected SearchMode getMode(RequestContext context) {
        SearchMode mode;
        ParameterMap map = context.getRequestParameters();
        String lastModeParameter = (String)map.get(PARAMETER_LAST_MODE, String.class);
        if (Boolean.parseBoolean(lastModeParameter)) {
            mode = this.getSearchHolder(context).getLastMode();
        } else {
            String modeParameter = (String)map.get(PARAMETER_MODE, String.class);
            mode = SearchMode.getMode(modeParameter);
        }
        return mode;
    }

    protected Object getParameter(RequestContext context, String name, Class clazz) {
        ParameterMap map = context.getRequestParameters();
        if (map.contains(name)) {
            return map.get(name, clazz);
        }
        return null;
    }
}

