/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.unitils.core.UnitilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    public static <T extends Annotation> Set<Field> getFieldsAnnotatedWith(Class<? extends Object> clazz, Class<T> annotation) {
        Field[] fields;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            annotatedFields.add(field);
        }
        annotatedFields.addAll(AnnotationUtils.getFieldsAnnotatedWith(clazz.getSuperclass(), annotation));
        return annotatedFields;
    }

    public static <T extends Annotation> Set<Method> getMethodsAnnotatedWith(Class<?> clazz, Class<T> annotation) {
        return AnnotationUtils.getMethodsAnnotatedWith(clazz, annotation, true);
    }

    public static <T extends Annotation> Set<T> getMethodLevelAnnotations(Class<?> clazz, Class<T> annotation) {
        HashSet<T> result = new HashSet<T>();
        Set<Method> annotatedMethods = AnnotationUtils.getMethodsAnnotatedWith(clazz, annotation);
        for (Method annotatedMethod : annotatedMethods) {
            result.add(annotatedMethod.getAnnotation(annotation));
        }
        return result;
    }

    public static <T extends Annotation> Set<T> getFieldLevelAnnotations(Class<?> clazz, Class<T> annotation) {
        HashSet<T> result = new HashSet<T>();
        Set<Field> annotatedFields = AnnotationUtils.getFieldsAnnotatedWith(clazz, annotation);
        for (Field annotatedField : annotatedFields) {
            result.add(annotatedField.getAnnotation(annotation));
        }
        return result;
    }

    public static <T extends Annotation> Set<Method> getMethodsAnnotatedWith(Class<?> clazz, Class<T> annotation, boolean includeInherited) {
        Method[] methods;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Method> annotatedMethods = new HashSet<Method>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            annotatedMethods.add(method);
        }
        if (includeInherited) {
            annotatedMethods.addAll(AnnotationUtils.getMethodsAnnotatedWith(clazz.getSuperclass(), annotation));
        }
        return annotatedMethods;
    }

    public static <T extends Annotation> T getMethodOrClassLevelAnnotation(Class<T> annotationClass, Method method, Class<?> clazz) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return AnnotationUtils.getClassLevelAnnotation(annotationClass, clazz);
    }

    public static <T extends Annotation> T getClassLevelAnnotation(Class<T> annotationClass, Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return AnnotationUtils.getClassLevelAnnotation(annotationClass, clazz.getSuperclass());
    }

    public static <S extends Annotation, T> T getMethodOrClassLevelAnnotationProperty(Class<S> annotationClass, String annotationPropertyName, T defaultValue, Method method, Class<?> clazz) {
        Method annotationProperty;
        T propertyValue;
        S annotation = method.getAnnotation(annotationClass);
        if (annotation != null && !defaultValue.equals(propertyValue = AnnotationUtils.getAnnotationPropertyValue(annotationProperty = AnnotationUtils.getAnnotationPropertyWithName(annotationClass, annotationPropertyName), annotation))) {
            return propertyValue;
        }
        return AnnotationUtils.getClassLevelAnnotationProperty(annotationClass, annotationPropertyName, defaultValue, clazz);
    }

    public static <S extends Annotation, T> T getClassLevelAnnotationProperty(Class<S> annotationClass, String annotationPropertyName, T defaultValue, Class<?> clazz) {
        Method annotationProperty;
        T propertyValue;
        if (Object.class.equals(clazz)) {
            return defaultValue;
        }
        S annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null && !defaultValue.equals(propertyValue = AnnotationUtils.getAnnotationPropertyValue(annotationProperty = AnnotationUtils.getAnnotationPropertyWithName(annotationClass, annotationPropertyName), annotation))) {
            return propertyValue;
        }
        return AnnotationUtils.getClassLevelAnnotationProperty(annotationClass, annotationPropertyName, defaultValue, clazz.getSuperclass());
    }

    public static Method getAnnotationPropertyWithName(Class<? extends Annotation> annotation, String annotationPropertyName) {
        try {
            return annotation.getMethod(annotationPropertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new UnitilsException("Could not find annotation property named " + annotationPropertyName + " on annotation " + annotation.getName());
        }
    }

    public static <T> T getAnnotationPropertyValue(Method annotationProperty, Annotation annotation) {
        try {
            return (T)annotationProperty.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnitilsException("Error retrieving value of property " + annotationProperty.getName() + " of annotation of type " + annotation.getClass().getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            throw new UnitilsException("Error retrieving value of property " + annotationProperty.getName() + " of annotation of type " + annotation.getClass().getSimpleName(), e);
        }
    }

    public static boolean hasClassMethodOrFieldLevelAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return AnnotationUtils.getClassLevelAnnotation(annotation, clazz) != null || !AnnotationUtils.getFieldsAnnotatedWith(clazz, annotation).isEmpty() || !AnnotationUtils.getMethodsAnnotatedWith(clazz, annotation).isEmpty();
    }
}

