/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.jpa.util.provider.hibernate;

import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceProvider;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.ejb.Ejb3Configuration;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.unitils.core.UnitilsException;
import org.unitils.orm.hibernate.util.HibernateAssert;
import org.unitils.orm.jpa.util.JpaProviderSupport;
import org.unitils.orm.jpa.util.provider.hibernate.UnitilsHibernateJpaVendorAdapter;
import org.unitils.orm.jpa.util.provider.hibernate.UnitilsHibernatePersistenceProvider;

public class HibernateJpaProviderSupport
implements JpaProviderSupport {
    public void assertMappingWithDatabaseConsistent(EntityManager entityManager, Object configurationObject) {
        Ejb3Configuration configuration = (Ejb3Configuration)configurationObject;
        Dialect databaseDialect = this.getHibernateDatabaseDialect(configuration);
        HibernateAssert.assertMappingWithDatabaseConsistent((Configuration)configuration.getHibernateConfiguration(), (Session)entityManager.getDelegate(), databaseDialect);
    }

    protected Dialect getHibernateDatabaseDialect(Ejb3Configuration configuration) {
        String dialectClassName = configuration.getProperties().getProperty("hibernate.dialect");
        if (StringUtils.isEmpty((String)dialectClassName)) {
            throw new UnitilsException("Property hibernate.dialect not specified");
        }
        try {
            return (Dialect)Class.forName(dialectClassName).newInstance();
        }
        catch (Exception e) {
            throw new UnitilsException("Could not instantiate dialect class " + dialectClassName, e);
        }
    }

    public JpaVendorAdapter getSpringJpaVendorAdaptor() {
        return new UnitilsHibernateJpaVendorAdapter();
    }

    public Object getProviderSpecificConfigurationObject(PersistenceProvider persistenceProvider) {
        if (!(persistenceProvider instanceof UnitilsHibernatePersistenceProvider)) {
            throw new UnitilsException("Make sure that the persistence provider that is used is an instance of " + UnitilsHibernatePersistenceProvider.class.getSimpleName());
        }
        UnitilsHibernatePersistenceProvider hibernatePersistenceProvider = (UnitilsHibernatePersistenceProvider)persistenceProvider;
        return hibernatePersistenceProvider.getHibernateConfiguration();
    }

    public LoadTimeWeaver getLoadTimeWeaver() {
        return null;
    }
}

