/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.dataset.comparison;

import java.util.ArrayList;
import java.util.List;
import org.unitils.dbunit.dataset.Column;
import org.unitils.dbunit.dataset.Row;
import org.unitils.dbunit.dataset.comparison.ColumnDifference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowDifference {
    private Row row;
    private Row actualRow;
    private List<Column> missingColumns = new ArrayList<Column>();
    private List<ColumnDifference> columnDifferences = new ArrayList<ColumnDifference>();

    public RowDifference(Row row, Row actualRow) {
        this.row = row;
        this.actualRow = actualRow;
    }

    public Row getRow() {
        return this.row;
    }

    public Row getActualRow() {
        return this.actualRow;
    }

    public List<ColumnDifference> getColumnDifferences() {
        return this.columnDifferences;
    }

    public List<Column> getMissingColumns() {
        return this.missingColumns;
    }

    public ColumnDifference getColumnDifference(String columnName) {
        for (ColumnDifference columnDifference : this.columnDifferences) {
            if (!columnName.equals(columnDifference.getColumn().getName())) continue;
            return columnDifference;
        }
        return null;
    }

    public void addColumnDifference(ColumnDifference columnDifference) {
        this.columnDifferences.add(columnDifference);
    }

    public void addMissingColumn(Column column) {
        this.missingColumns.add(column);
    }

    public boolean isBetterMatch(RowDifference rowComparison) {
        return this.columnDifferences.size() + this.missingColumns.size() < rowComparison.getMissingColumns().size() + rowComparison.getColumnDifferences().size();
    }

    public boolean isMatch() {
        return this.columnDifferences.isEmpty() && this.missingColumns.isEmpty();
    }
}

