/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.factory;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.ChainedTilesRequestContextFactory;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.LocaleDefinitionsFactory;
import org.apache.tiles.definition.Refreshable;
import org.apache.tiles.definition.UrlDefinitionsFactory;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.DefinitionDAO;
import org.apache.tiles.definition.dao.ResolvingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.factory.NotAvailableFeatureException;
import org.apache.tiles.factory.TilesContainerFactoryException;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.locale.impl.DefaultLocaleResolver;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.reflect.ClassUtil;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.RendererFactory;
import org.apache.tiles.renderer.impl.BasicRendererFactory;
import org.apache.tiles.renderer.impl.DefinitionAttributeRenderer;
import org.apache.tiles.renderer.impl.StringAttributeRenderer;
import org.apache.tiles.renderer.impl.TemplateAttributeRenderer;
import org.apache.tiles.renderer.impl.UntypedAttributeRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTilesContainerFactory
extends AbstractTilesContainerFactory {
    private static final int CONTEXT_FACTORY_CHAIN_COUNT = 3;
    private final Log log = LogFactory.getLog(BasicTilesContainerFactory.class);

    @Override
    public TilesContainer createContainer(TilesApplicationContext applicationContext) {
        BasicTilesContainer container = this.instantiateContainer(applicationContext);
        TilesRequestContextFactory requestContextFactory = this.createRequestContextFactory(applicationContext);
        container.setRequestContextFactory(requestContextFactory);
        container.setApplicationContext(applicationContext);
        LocaleResolver resolver = this.createLocaleResolver(applicationContext, requestContextFactory);
        container.setDefinitionsFactory(this.createDefinitionsFactory(applicationContext, requestContextFactory, resolver));
        AttributeEvaluator evaluator = this.createEvaluator(applicationContext, requestContextFactory, resolver);
        container.setEvaluator(evaluator);
        container.setPreparerFactory(this.createPreparerFactory(applicationContext, requestContextFactory));
        container.setRendererFactory(this.createRendererFactory(applicationContext, requestContextFactory, container, evaluator));
        return container;
    }

    protected BasicTilesContainer instantiateContainer(TilesApplicationContext context) {
        return new BasicTilesContainer();
    }

    protected TilesRequestContextFactory createRequestContextFactory(TilesApplicationContext context) {
        ChainedTilesRequestContextFactory contextFactory = new ChainedTilesRequestContextFactory();
        this.registerChainedRequestContextFactories(contextFactory);
        return contextFactory;
    }

    protected void registerChainedRequestContextFactories(ChainedTilesRequestContextFactory contextFactory) {
        ArrayList<TilesRequestContextFactory> factories = new ArrayList<TilesRequestContextFactory>(3);
        this.registerRequestContextFactory("org.apache.tiles.servlet.context.ServletTilesRequestContextFactory", factories, contextFactory);
        this.registerRequestContextFactory("org.apache.tiles.portlet.context.PortletTilesRequestContextFactory", factories, contextFactory);
        this.registerRequestContextFactory("org.apache.tiles.jsp.context.JspTilesRequestContextFactory", factories, contextFactory);
        contextFactory.setFactories(factories);
    }

    protected void registerRequestContextFactory(String className, List<TilesRequestContextFactory> factories, TilesRequestContextFactory parent) {
        TilesRequestContextFactory retValue = null;
        try {
            Class clazz = ClassUtil.getClass((String)className, TilesRequestContextFactory.class);
            retValue = (TilesRequestContextFactory)clazz.newInstance();
            if (parent != null && retValue instanceof TilesRequestContextFactoryAware) {
                ((TilesRequestContextFactoryAware)((Object)retValue)).setRequestContextFactory(parent);
            }
        }
        catch (ClassNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot find class '" + className + "', ignoring problem"), (Throwable)e);
            }
        }
        catch (NotAvailableFeatureException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not available feature exception during instantiation of class '" + className + "', ignoring problem"), (Throwable)((Object)e));
            }
        }
        catch (InstantiationException e) {
            throw new TilesContainerFactoryException("Cannot instantiate '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new TilesContainerFactoryException("Cannot access default constructor '" + className + "'", e);
        }
        if (retValue != null) {
            factories.add(retValue);
        }
    }

    protected DefinitionsFactory createDefinitionsFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        LocaleDefinitionsFactory factory = this.instantiateDefinitionsFactory(applicationContext, contextFactory, resolver);
        factory.setApplicationContext(applicationContext);
        factory.setLocaleResolver(resolver);
        factory.setDefinitionDAO(this.createLocaleDefinitionDao(applicationContext, contextFactory, resolver));
        if (factory instanceof Refreshable) {
            ((Refreshable)((Object)factory)).refresh();
        }
        return factory;
    }

    protected LocaleDefinitionsFactory instantiateDefinitionsFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        return new UrlDefinitionsFactory();
    }

    protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        return new ResolvingLocaleUrlDefinitionDAO();
    }

    protected DefinitionDAO<Locale> createLocaleDefinitionDao(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        BaseLocaleUrlDefinitionDAO definitionDao = this.instantiateLocaleDefinitionDao(applicationContext, contextFactory, resolver);
        definitionDao.setReader(this.createDefinitionsReader(applicationContext, contextFactory));
        definitionDao.setSourceURLs(this.getSourceURLs(applicationContext, contextFactory));
        definitionDao.setApplicationContext(applicationContext);
        return definitionDao;
    }

    protected LocaleResolver createLocaleResolver(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        return new DefaultLocaleResolver();
    }

    protected DefinitionsReader createDefinitionsReader(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        return new DigesterDefinitionsReader();
    }

    protected List<URL> getSourceURLs(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        ArrayList<URL> retValue = new ArrayList<URL>(1);
        try {
            retValue.add(applicationContext.getResource("/WEB-INF/tiles.xml"));
        }
        catch (IOException e) {
            throw new TilesContainerFactoryException("Cannot get URL: /WEB-INF/tiles.xml", e);
        }
        return retValue;
    }

    protected AttributeEvaluator createEvaluator(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        return new DirectAttributeEvaluator();
    }

    protected PreparerFactory createPreparerFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        return new BasicPreparerFactory();
    }

    protected RendererFactory createRendererFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluator evaluator) {
        BasicRendererFactory retValue = new BasicRendererFactory();
        retValue.setApplicationContext(applicationContext);
        retValue.setRequestContextFactory(contextFactory);
        retValue.setContainer(container);
        retValue.setEvaluator(evaluator);
        retValue.setDefaultRenderer(this.createDefaultAttributeRenderer(applicationContext, contextFactory, container, evaluator));
        this.registerAttributeRenderers(retValue, applicationContext, contextFactory, container, evaluator);
        return retValue;
    }

    protected AttributeRenderer createDefaultAttributeRenderer(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluator evaluator) {
        UntypedAttributeRenderer retValue = new UntypedAttributeRenderer();
        retValue.setApplicationContext(applicationContext);
        retValue.setContainer(container);
        retValue.setRequestContextFactory(contextFactory);
        retValue.setEvaluator(evaluator);
        return retValue;
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluator evaluator) {
        StringAttributeRenderer stringRenderer = new StringAttributeRenderer();
        stringRenderer.setApplicationContext(applicationContext);
        stringRenderer.setRequestContextFactory(contextFactory);
        stringRenderer.setEvaluator(evaluator);
        rendererFactory.registerRenderer("string", stringRenderer);
        TemplateAttributeRenderer templateRenderer = new TemplateAttributeRenderer();
        templateRenderer.setApplicationContext(applicationContext);
        templateRenderer.setRequestContextFactory(contextFactory);
        templateRenderer.setEvaluator(evaluator);
        rendererFactory.registerRenderer("template", templateRenderer);
        DefinitionAttributeRenderer definitionRenderer = new DefinitionAttributeRenderer();
        definitionRenderer.setApplicationContext(applicationContext);
        definitionRenderer.setContainer(container);
        definitionRenderer.setRequestContextFactory(contextFactory);
        definitionRenderer.setEvaluator(evaluator);
        rendererFactory.registerRenderer("definition", definitionRenderer);
    }
}

