/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.util.StringSplitUtils;
import org.springframework.util.StringUtils;

public class StringSplitUtilsTests
extends TestCase {
    public StringSplitUtilsTests() {
    }

    public StringSplitUtilsTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(StringSplitUtilsTests.class);
    }

    public void testSplitEachArrayElementAndCreateMapNormalOperation() {
        String unsplit = "username=\"rod\", invalidEntryThatHasNoEqualsSign, realm=\"Contacts Realm\", nonce=\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\", uri=\"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\", response=\"38644211cf9ac3da63ab639807e2baff\", qop=auth, nc=00000004, cnonce=\"2b8d329a8571b99a\"";
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)unsplit);
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        StringSplitUtilsTests.assertEquals((Object)"rod", headerMap.get("username"));
        StringSplitUtilsTests.assertEquals((Object)"Contacts Realm", headerMap.get("realm"));
        StringSplitUtilsTests.assertEquals((Object)"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==", headerMap.get("nonce"));
        StringSplitUtilsTests.assertEquals((Object)"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4", headerMap.get("uri"));
        StringSplitUtilsTests.assertEquals((Object)"38644211cf9ac3da63ab639807e2baff", headerMap.get("response"));
        StringSplitUtilsTests.assertEquals((Object)"auth", headerMap.get("qop"));
        StringSplitUtilsTests.assertEquals((Object)"00000004", headerMap.get("nc"));
        StringSplitUtilsTests.assertEquals((Object)"2b8d329a8571b99a", headerMap.get("cnonce"));
        StringSplitUtilsTests.assertEquals((int)8, (int)headerMap.size());
    }

    public void testSplitEachArrayElementAndCreateMapRespectsInstructionNotToRemoveCharacters() {
        String unsplit = "username=\"rod\", realm=\"Contacts Realm\", nonce=\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\", uri=\"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\", response=\"38644211cf9ac3da63ab639807e2baff\", qop=auth, nc=00000004, cnonce=\"2b8d329a8571b99a\"";
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)unsplit);
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", null);
        StringSplitUtilsTests.assertEquals((Object)"\"rod\"", headerMap.get("username"));
        StringSplitUtilsTests.assertEquals((Object)"\"Contacts Realm\"", headerMap.get("realm"));
        StringSplitUtilsTests.assertEquals((Object)"\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\"", headerMap.get("nonce"));
        StringSplitUtilsTests.assertEquals((Object)"\"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\"", headerMap.get("uri"));
        StringSplitUtilsTests.assertEquals((Object)"\"38644211cf9ac3da63ab639807e2baff\"", headerMap.get("response"));
        StringSplitUtilsTests.assertEquals((Object)"auth", headerMap.get("qop"));
        StringSplitUtilsTests.assertEquals((Object)"00000004", headerMap.get("nc"));
        StringSplitUtilsTests.assertEquals((Object)"\"2b8d329a8571b99a\"", headerMap.get("cnonce"));
        StringSplitUtilsTests.assertEquals((int)8, (int)headerMap.size());
    }

    public void testSplitEachArrayElementAndCreateMapReturnsNullIfArrayEmptyOrNull() {
        StringSplitUtilsTests.assertNull((Object)StringSplitUtils.splitEachArrayElementAndCreateMap(null, (String)"=", (String)"\""));
        StringSplitUtilsTests.assertNull((Object)StringSplitUtils.splitEachArrayElementAndCreateMap((String[])new String[0], (String)"=", (String)"\""));
    }

    public void testSplitNormalOperation() {
        String unsplit = "username=\"rod==\"";
        StringSplitUtilsTests.assertEquals((String)"username", (String)StringSplitUtils.split((String)unsplit, (String)"=")[0]);
        StringSplitUtilsTests.assertEquals((String)"\"rod==\"", (String)StringSplitUtils.split((String)unsplit, (String)"=")[1]);
    }

    public void testSplitRejectsNullsAndIncorrectLengthStrings() {
        try {
            StringSplitUtils.split(null, (String)"=");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"", (String)"=");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"sdch=dfgf", null);
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"fvfv=dcdc", (String)"");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"dfdc=dcdc", (String)"BIGGER_THAN_ONE_CHARACTER");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testSplitWorksWithDifferentDelimiters() {
        StringSplitUtilsTests.assertEquals((int)2, (int)StringSplitUtils.split((String)"18/rod", (String)"/").length);
        StringSplitUtilsTests.assertNull((Object)StringSplitUtils.split((String)"18/rod", (String)"!"));
        StringSplitUtilsTests.assertEquals((int)2, (int)StringSplitUtils.split((String)"18|rod|foo|bar", (String)"|").length);
    }

    public void testAuthorizationHeaderWithCommasIsSplitCorrectly() {
        String header = "Digest username=\"hamilton,bob\", realm=\"bobs,ok,realm\", nonce=\"the,nonce\", uri=\"the,Uri\", response=\"the,response,Digest\", qop=theqop, nc=thenc, cnonce=\"the,cnonce\"";
        String[] parts = StringSplitUtils.splitIgnoringQuotes((String)header, (char)',');
        StringSplitUtilsTests.assertEquals((int)8, (int)parts.length);
    }
}

