/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.memory;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.memory.UserMap;

public class UserMapTests
extends TestCase {
    public UserMapTests() {
    }

    public UserMapTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(UserMapTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAddAndRetrieveUser() {
        User rod = new User("rod", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        User scott = new User("scott", "wombat", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_THREE")});
        User peter = new User("peter", "opal", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_FOUR")});
        UserMap map = new UserMap();
        map.addUser((UserDetails)rod);
        map.addUser((UserDetails)scott);
        map.addUser((UserDetails)peter);
        UserMapTests.assertEquals((int)3, (int)map.getUserCount());
        UserMapTests.assertEquals((Object)rod, (Object)map.getUser("rod"));
        UserMapTests.assertEquals((Object)scott, (Object)map.getUser("scott"));
        UserMapTests.assertEquals((Object)peter, (Object)map.getUser("peter"));
    }

    public void testNullUserCannotBeAdded() {
        UserMap map = new UserMap();
        UserMapTests.assertEquals((int)0, (int)map.getUserCount());
        try {
            map.addUser(null);
            UserMapTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            UserMapTests.assertTrue((boolean)true);
        }
    }

    public void testUnknownUserIsNotRetrieved() {
        User rod = new User("rod", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        UserMap map = new UserMap();
        UserMapTests.assertEquals((int)0, (int)map.getUserCount());
        map.addUser((UserDetails)rod);
        UserMapTests.assertEquals((int)1, (int)map.getUserCount());
        try {
            map.getUser("scott");
            UserMapTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            UserMapTests.assertTrue((boolean)true);
        }
    }
}

