/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import java.util.Set;
import javax.naming.Name;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.LdapUserSearch;
import org.springframework.security.providers.ldap.authenticator.MockUserSearch;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsMapper;
import org.springframework.security.userdetails.ldap.LdapUserDetailsService;
import org.springframework.security.userdetails.ldap.UserDetailsContextMapper;
import org.springframework.security.util.AuthorityUtils;

public class LdapUserDetailsServiceTests {
    @Test(expected=IllegalArgumentException.class)
    public void rejectsNullSearchObject() {
        new LdapUserDetailsService(null, (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
    }

    @Test(expected=IllegalArgumentException.class)
    public void rejectsNullAuthoritiesPopulator() {
        new LdapUserDetailsService((LdapUserSearch)new MockUserSearch(), null);
    }

    @Test
    public void correctAuthoritiesAreReturned() {
        DirContextAdapter userData = new DirContextAdapter((Name)new DistinguishedName("uid=joe"));
        LdapUserDetailsService service = new LdapUserDetailsService((LdapUserSearch)new MockUserSearch((DirContextOperations)userData), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        service.setUserDetailsMapper((UserDetailsContextMapper)new LdapUserDetailsMapper());
        UserDetails user = service.loadUserByUsername("doesntmatterwegetjoeanyway");
        Set authorities = AuthorityUtils.authorityArrayToSet((GrantedAuthority[])user.getAuthorities());
        Assert.assertEquals((long)1L, (long)authorities.size());
        Assert.assertTrue((boolean)authorities.contains("ROLE_FROM_POPULATOR"));
    }

    class MockAuthoritiesPopulator
    implements LdapAuthoritiesPopulator {
        MockAuthoritiesPopulator() {
        }

        public GrantedAuthority[] getGrantedAuthorities(DirContextOperations userCtx, String username) {
            return new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FROM_POPULATOR")};
        }
    }
}

