/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.hierarchicalroles;

import junit.textui.TestRunner;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Constraint;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.hierarchicalroles.HierarchicalRolesTestHelper;
import org.springframework.security.userdetails.hierarchicalroles.RoleHierarchy;
import org.springframework.security.userdetails.hierarchicalroles.RoleHierarchyImpl;
import org.springframework.security.userdetails.hierarchicalroles.UserDetailsServiceWrapper;

public class UserDetailsServiceWrapperTests
extends MockObjectTestCase {
    private UserDetailsService wrappedUserDetailsService = null;
    private UserDetailsServiceWrapper userDetailsServiceWrapper = null;

    public UserDetailsServiceWrapperTests() {
    }

    public UserDetailsServiceWrapperTests(String testCaseName) {
        super(testCaseName);
    }

    public static void main(String[] args) {
        TestRunner.run(UserDetailsServiceWrapperTests.class);
    }

    protected void setUp() throws Exception {
        RoleHierarchyImpl roleHierarchy = new RoleHierarchyImpl();
        roleHierarchy.setHierarchy("ROLE_A > ROLE_B");
        GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")};
        User user = new User("EXISTING_USER", "PASSWORD", true, true, true, true, authorities);
        Mock wrappedUserDetailsServiceMock = this.mock(UserDetailsService.class);
        wrappedUserDetailsServiceMock.stubs().method("loadUserByUsername").with((Constraint)this.eq("EXISTING_USER")).will(this.returnValue(user));
        wrappedUserDetailsServiceMock.stubs().method("loadUserByUsername").with((Constraint)this.eq("USERNAME_NOT_FOUND_EXCEPTION")).will(this.throwException(new UsernameNotFoundException("USERNAME_NOT_FOUND_EXCEPTION")));
        wrappedUserDetailsServiceMock.stubs().method("loadUserByUsername").with((Constraint)this.eq("DATA_ACCESS_EXCEPTION")).will(this.throwException((Throwable)new EmptyResultDataAccessException(1234)));
        this.wrappedUserDetailsService = (UserDetailsService)wrappedUserDetailsServiceMock.proxy();
        this.userDetailsServiceWrapper = new UserDetailsServiceWrapper();
        this.userDetailsServiceWrapper.setRoleHierarchy((RoleHierarchy)roleHierarchy);
        this.userDetailsServiceWrapper.setUserDetailsService(this.wrappedUserDetailsService);
    }

    public void testLoadUserByUsername() {
        GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B")};
        User expectedUserDetails = new User("EXISTING_USER", "PASSWORD", true, true, true, true, authorities);
        UserDetails userDetails = this.userDetailsServiceWrapper.loadUserByUsername("EXISTING_USER");
        UserDetailsServiceWrapperTests.assertEquals((String)expectedUserDetails.getPassword(), (String)userDetails.getPassword());
        UserDetailsServiceWrapperTests.assertEquals((String)expectedUserDetails.getUsername(), (String)userDetails.getUsername());
        UserDetailsServiceWrapperTests.assertEquals((boolean)expectedUserDetails.isAccountNonExpired(), (boolean)userDetails.isAccountNonExpired());
        UserDetailsServiceWrapperTests.assertEquals((boolean)expectedUserDetails.isAccountNonLocked(), (boolean)userDetails.isAccountNonLocked());
        UserDetailsServiceWrapperTests.assertEquals((boolean)expectedUserDetails.isCredentialsNonExpired(), (boolean)expectedUserDetails.isCredentialsNonExpired());
        UserDetailsServiceWrapperTests.assertEquals((boolean)expectedUserDetails.isEnabled(), (boolean)userDetails.isEnabled());
        UserDetailsServiceWrapperTests.assertTrue((boolean)HierarchicalRolesTestHelper.containTheSameGrantedAuthorities(expectedUserDetails.getAuthorities(), userDetails.getAuthorities()));
        try {
            userDetails = this.userDetailsServiceWrapper.loadUserByUsername("USERNAME_NOT_FOUND_EXCEPTION");
            UserDetailsServiceWrapperTests.fail((String)"testLoadUserByUsername() - UsernameNotFoundException did not bubble up!");
        }
        catch (UsernameNotFoundException e) {
            // empty catch block
        }
        try {
            userDetails = this.userDetailsServiceWrapper.loadUserByUsername("DATA_ACCESS_EXCEPTION");
            UserDetailsServiceWrapperTests.fail((String)"testLoadUserByUsername() - DataAccessException did not bubble up!");
        }
        catch (DataAccessException e) {
            // empty catch block
        }
    }

    public void testGetWrappedUserDetailsService() {
        UserDetailsServiceWrapperTests.assertTrue((this.userDetailsServiceWrapper.getWrappedUserDetailsService() == this.wrappedUserDetailsService ? 1 : 0) != 0);
    }
}

