/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.savedrequest;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import junit.framework.TestCase;
import org.springframework.security.ui.savedrequest.SavedCookie;

public class SavedCookieTests
extends TestCase {
    Cookie cookie;
    SavedCookie savedCookie;

    protected void setUp() throws Exception {
        this.cookie = new Cookie("name", "value");
        this.cookie.setComment("comment");
        this.cookie.setDomain("domain");
        this.cookie.setMaxAge(100);
        this.cookie.setPath("path");
        this.cookie.setSecure(true);
        this.cookie.setVersion(11);
        this.savedCookie = new SavedCookie(this.cookie);
    }

    public void testGetName() throws Exception {
        SavedCookieTests.assertEquals((String)this.cookie.getName(), (String)this.savedCookie.getName());
    }

    public void testGetValue() throws Exception {
        SavedCookieTests.assertEquals((String)this.cookie.getValue(), (String)this.savedCookie.getValue());
    }

    public void testGetComment() throws Exception {
        SavedCookieTests.assertEquals((String)this.cookie.getComment(), (String)this.savedCookie.getComment());
    }

    public void testGetDomain() throws Exception {
        SavedCookieTests.assertEquals((String)this.cookie.getDomain(), (String)this.savedCookie.getDomain());
    }

    public void testGetMaxAge() throws Exception {
        SavedCookieTests.assertEquals((int)this.cookie.getMaxAge(), (int)this.savedCookie.getMaxAge());
    }

    public void testGetPath() throws Exception {
        SavedCookieTests.assertEquals((String)this.cookie.getPath(), (String)this.savedCookie.getPath());
    }

    public void testGetVersion() throws Exception {
        SavedCookieTests.assertEquals((int)this.cookie.getVersion(), (int)this.savedCookie.getVersion());
    }

    public void testGetCookie() throws Exception {
        Cookie other = this.savedCookie.getCookie();
        SavedCookieTests.assertEquals((String)this.cookie.getComment(), (String)other.getComment());
        SavedCookieTests.assertEquals((String)this.cookie.getDomain(), (String)other.getDomain());
        SavedCookieTests.assertEquals((int)this.cookie.getMaxAge(), (int)other.getMaxAge());
        SavedCookieTests.assertEquals((String)this.cookie.getName(), (String)other.getName());
        SavedCookieTests.assertEquals((String)this.cookie.getPath(), (String)other.getPath());
        SavedCookieTests.assertEquals((boolean)this.cookie.getSecure(), (boolean)other.getSecure());
        SavedCookieTests.assertEquals((String)this.cookie.getValue(), (String)other.getValue());
        SavedCookieTests.assertEquals((int)this.cookie.getVersion(), (int)other.getVersion());
    }

    public void testSerializable() throws Exception {
        SavedCookieTests.assertTrue((boolean)(this.savedCookie instanceof Serializable));
    }
}

