/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.rememberme;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.MockApplicationEventPublisher;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.MockFilterConfig;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.ui.rememberme.NullRememberMeServices;
import org.springframework.security.ui.rememberme.RememberMeProcessingFilter;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.security.ui.rememberme.TokenBasedRememberMeServices;

public class RememberMeProcessingFilterTests
extends TestCase {
    public RememberMeProcessingFilterTests() {
    }

    public RememberMeProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDetectsAuthenticationManagerProperty() throws Exception {
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
        filter.afterPropertiesSet();
        RememberMeProcessingFilterTests.assertTrue((boolean)true);
        filter.setAuthenticationManager(null);
        try {
            filter.afterPropertiesSet();
            RememberMeProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeProcessingFilterTests.assertTrue((boolean)true);
        }
    }

    public void testDetectsRememberMeServicesProperty() throws Exception {
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setRememberMeServices((RememberMeServices)new TokenBasedRememberMeServices());
        RememberMeProcessingFilterTests.assertEquals(TokenBasedRememberMeServices.class, filter.getRememberMeServices().getClass());
        filter.setRememberMeServices(null);
        try {
            filter.afterPropertiesSet();
            RememberMeProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeProcessingFilterTests.assertTrue((boolean)true);
        }
    }

    public void testOperationWhenAuthenticationExistsInContextHolder() throws Exception {
        TestingAuthenticationToken originalAuth = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)originalAuth);
        TestingAuthenticationToken remembered = new TestingAuthenticationToken((Object)"remembered", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_REMEMBERED")});
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices((Authentication)remembered));
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeProcessingFilterTests.assertEquals((Object)((Object)originalAuth), (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testOperationWhenNoAuthenticationInContextHolder() throws Exception {
        TestingAuthenticationToken remembered = new TestingAuthenticationToken((Object)"remembered", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_REMEMBERED")});
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices((Authentication)remembered));
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeProcessingFilterTests.assertEquals((Object)((Object)remembered), (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testOnunsuccessfulLoginIsCalledWhenProviderRejectsAuth() throws Exception {
        TestingAuthenticationToken remembered = new TestingAuthenticationToken((Object)"remembered", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_REMEMBERED")});
        TestingAuthenticationToken failedAuth = new TestingAuthenticationToken("failed", "");
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter((Authentication)failedAuth){
            final /* synthetic */ Authentication val$failedAuth;
            {
                this.val$failedAuth = authentication;
            }

            protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
                super.onUnsuccessfulAuthentication(request, response, failed);
                SecurityContextHolder.getContext().setAuthentication(this.val$failedAuth);
            }
        };
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(false));
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices((Authentication)remembered));
        filter.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher());
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeProcessingFilterTests.assertEquals((Object)((Object)failedAuth), (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    private class MockRememberMeServices
    implements RememberMeServices {
        private Authentication authToReturn;

        public MockRememberMeServices(Authentication authToReturn) {
            this.authToReturn = authToReturn;
        }

        public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
            return this.authToReturn;
        }

        public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        }

        public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

