/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.jaas;

import junit.framework.Assert;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.jaas.AuthorityGranter;
import org.springframework.security.providers.jaas.JaasAuthenticationCallbackHandler;
import org.springframework.security.providers.jaas.JaasAuthenticationProvider;
import org.springframework.security.providers.jaas.JaasNameCallbackHandler;
import org.springframework.security.providers.jaas.JaasPasswordCallbackHandler;
import org.springframework.security.providers.jaas.TestAuthorityGranter;
import org.springframework.security.providers.jaas.TestCallbackHandler;

public class Sec760Tests {
    public String resolveConfigFile(String filename) {
        String resName = "/" + this.getClass().getPackage().getName().replace('.', '/') + filename;
        return resName;
    }

    private void testConfigureJaasCase(JaasAuthenticationProvider p1, JaasAuthenticationProvider p2) throws Exception {
        p1.setLoginConfig((Resource)new ClassPathResource(this.resolveConfigFile("/test1.conf")));
        p1.setLoginContextName("test1");
        p1.setCallbackHandlers(new JaasAuthenticationCallbackHandler[]{new TestCallbackHandler(), new JaasNameCallbackHandler(), new JaasPasswordCallbackHandler()});
        p1.setAuthorityGranters(new AuthorityGranter[]{new TestAuthorityGranter()});
        p1.afterPropertiesSet();
        this.testAuthenticate(p1);
        p2.setLoginConfig((Resource)new ClassPathResource(this.resolveConfigFile("/test2.conf")));
        p2.setLoginContextName("test2");
        p2.setCallbackHandlers(new JaasAuthenticationCallbackHandler[]{new TestCallbackHandler(), new JaasNameCallbackHandler(), new JaasPasswordCallbackHandler()});
        p2.setAuthorityGranters(new AuthorityGranter[]{new TestAuthorityGranter()});
        p2.afterPropertiesSet();
        this.testAuthenticate(p2);
    }

    private void testAuthenticate(JaasAuthenticationProvider p1) {
        GrantedAuthorityImpl role1 = new GrantedAuthorityImpl("ROLE_1");
        GrantedAuthorityImpl role2 = new GrantedAuthorityImpl("ROLE_2");
        GrantedAuthority[] defaultAuths = new GrantedAuthority[]{role1, role2};
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password", defaultAuths);
        Authentication auth = p1.authenticate((Authentication)token);
        Assert.assertNotNull((Object)auth);
    }

    @Test
    public void testConfigureJaas() throws Exception {
        this.testConfigureJaasCase(new JaasAuthenticationProvider(), new JaasAuthenticationProvider());
    }
}

