/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.dao.salt;

import junit.framework.Assert;
import org.junit.Test;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.dao.salt.ReflectionSaltSource;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;

public class ReflectionSaltSourceTests {
    private UserDetails user = new User("scott", "wombat", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});

    @Test(expected=IllegalArgumentException.class)
    public void detectsMissingUserPropertyToUse() throws Exception {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        saltSource.afterPropertiesSet();
    }

    @Test(expected=AuthenticationServiceException.class)
    public void exceptionIsThrownWhenInvalidPropertyRequested() throws Exception {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        saltSource.setUserPropertyToUse("getDoesNotExist");
        saltSource.afterPropertiesSet();
        saltSource.getSalt(this.user);
    }

    @Test
    public void methodNameAsPropertyToUseReturnsCorrectSaltValue() {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        saltSource.setUserPropertyToUse("getUsername");
        Assert.assertEquals((Object)"scott", (Object)saltSource.getSalt(this.user));
    }

    @Test
    public void propertyNameAsPropertyToUseReturnsCorrectSaltValue() {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        saltSource.setUserPropertyToUse("password");
        Assert.assertEquals((Object)"wombat", (Object)saltSource.getSalt(this.user));
    }
}

