/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.populator;

import java.util.HashSet;
import javax.naming.Name;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.populator.DefaultLdapAuthoritiesPopulator;

public class DefaultLdapAuthoritiesPopulatorTests
extends AbstractLdapIntegrationTests {
    private DefaultLdapAuthoritiesPopulator populator;

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.populator = new DefaultLdapAuthoritiesPopulator((ContextSource)this.getContextSource(), "ou=groups");
    }

    @Test
    public void testDefaultRoleIsAssignedWhenSet() {
        this.populator.setDefaultRole("ROLE_USER");
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("cn=notfound"));
        GrantedAuthority[] authorities = this.populator.getGrantedAuthorities((DirContextOperations)ctx, "notfound");
        Assert.assertEquals((long)1L, (long)authorities.length);
        Assert.assertEquals((Object)"ROLE_USER", (Object)authorities[0].getAuthority());
    }

    @Test
    public void testGroupSearchReturnsExpectedRoles() {
        this.populator.setRolePrefix("ROLE_");
        this.populator.setGroupRoleAttribute("ou");
        this.populator.setSearchSubtree(true);
        this.populator.setSearchSubtree(false);
        this.populator.setConvertToUpperCase(true);
        this.populator.setGroupSearchFilter("(member={0})");
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("uid=ben,ou=people,dc=springframework,dc=org"));
        GrantedAuthority[] authorities = this.populator.getGrantedAuthorities((DirContextOperations)ctx, "ben");
        Assert.assertEquals((String)"Should have 2 roles", (long)2L, (long)authorities.length);
        HashSet<String> roles = new HashSet<String>();
        roles.add(authorities[0].toString());
        roles.add(authorities[1].toString());
        Assert.assertTrue((boolean)roles.contains("ROLE_DEVELOPER"));
        Assert.assertTrue((boolean)roles.contains("ROLE_MANAGER"));
    }

    @Test
    public void testUseOfUsernameParameterReturnsExpectedRoles() {
        this.populator.setGroupRoleAttribute("ou");
        this.populator.setConvertToUpperCase(true);
        this.populator.setGroupSearchFilter("(ou={1})");
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("uid=ben,ou=people,dc=springframework,dc=org"));
        GrantedAuthority[] authorities = this.populator.getGrantedAuthorities((DirContextOperations)ctx, "manager");
        Assert.assertEquals((String)"Should have 1 role", (long)1L, (long)authorities.length);
        Assert.assertEquals((Object)"ROLE_MANAGER", (Object)authorities[0].getAuthority());
    }

    @Test
    public void testSubGroupRolesAreNotFoundByDefault() {
        this.populator.setGroupRoleAttribute("ou");
        this.populator.setConvertToUpperCase(true);
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("uid=ben,ou=people,dc=springframework,dc=org"));
        GrantedAuthority[] authorities = this.populator.getGrantedAuthorities((DirContextOperations)ctx, "manager");
        Assert.assertEquals((String)"Should have 2 roles", (long)2L, (long)authorities.length);
        HashSet<String> roles = new HashSet<String>(2);
        roles.add(authorities[0].getAuthority());
        roles.add(authorities[1].getAuthority());
        Assert.assertTrue((boolean)roles.contains("ROLE_MANAGER"));
        Assert.assertTrue((boolean)roles.contains("ROLE_DEVELOPER"));
    }

    @Test
    public void testSubGroupRolesAreFoundWhenSubtreeSearchIsEnabled() {
        this.populator.setGroupRoleAttribute("ou");
        this.populator.setConvertToUpperCase(true);
        this.populator.setSearchSubtree(true);
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("uid=ben,ou=people,dc=springframework,dc=org"));
        GrantedAuthority[] authorities = this.populator.getGrantedAuthorities((DirContextOperations)ctx, "manager");
        Assert.assertEquals((String)"Should have 3 roles", (long)3L, (long)authorities.length);
        HashSet<String> roles = new HashSet<String>(3);
        roles.add(authorities[0].getAuthority());
        roles.add(authorities[1].getAuthority());
        roles.add(authorities[2].getAuthority());
        Assert.assertTrue((boolean)roles.contains("ROLE_MANAGER"));
        Assert.assertTrue((boolean)roles.contains("ROLE_DEVELOPER"));
        Assert.assertTrue((boolean)roles.contains("ROLE_SUBMANAGER"));
    }

    @Test
    public void testUserDnWithEscapedCharacterParameterReturnsExpectedRoles() {
        this.populator.setGroupRoleAttribute("ou");
        this.populator.setConvertToUpperCase(true);
        this.populator.setGroupSearchFilter("(member={0})");
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("cn=mouse\\, jerry,ou=people,dc=springframework,dc=org"));
        GrantedAuthority[] authorities = this.populator.getGrantedAuthorities((DirContextOperations)ctx, "notused");
        Assert.assertEquals((String)"Should have 1 role", (long)1L, (long)authorities.length);
        Assert.assertEquals((Object)"ROLE_MANAGER", (Object)authorities[0].getAuthority());
    }
}

