/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

public class SpringSecurityLdapTemplateTests
extends AbstractLdapIntegrationTests {
    private SpringSecurityLdapTemplate template;

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.template = new SpringSecurityLdapTemplate((ContextSource)this.getContextSource());
    }

    @Test
    public void compareOfCorrectValueSucceeds() {
        Assert.assertTrue((boolean)this.template.compare("uid=bob,ou=people", "uid", (Object)"bob"));
    }

    @Test
    public void compareOfCorrectByteValueSucceeds() {
        Assert.assertTrue((boolean)this.template.compare("uid=bob,ou=people", "userPassword", (Object)LdapUtils.getUtf8Bytes((String)"bobspassword")));
    }

    @Test
    public void compareOfWrongByteValueFails() {
        Assert.assertFalse((boolean)this.template.compare("uid=bob,ou=people", "userPassword", (Object)LdapUtils.getUtf8Bytes((String)"wrongvalue")));
    }

    @Test
    public void compareOfWrongValueFails() {
        Assert.assertFalse((boolean)this.template.compare("uid=bob,ou=people", "uid", (Object)"wrongvalue"));
    }

    @Test
    public void namingExceptionIsTranslatedCorrectly() {
        try {
            this.template.executeReadOnly(new ContextExecutor(){

                public Object executeWithContext(DirContext dirContext) throws NamingException {
                    throw new NamingException();
                }
            });
            Assert.fail((String)"Expected UncategorizedLdapException on NamingException");
        }
        catch (UncategorizedLdapException uncategorizedLdapException) {
            // empty catch block
        }
    }

    @Test
    public void roleSearchReturnsCorrectNumberOfRoles() {
        String param = "uid=ben,ou=people,dc=springframework,dc=org";
        Set values = this.template.searchForSingleAttributeValues("ou=groups", "(member={0})", (Object[])new String[]{param}, "ou");
        Assert.assertEquals((String)"Expected 3 results from search", (long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("developer"));
        Assert.assertTrue((boolean)values.contains("manager"));
        Assert.assertTrue((boolean)values.contains("submanager"));
    }

    @Test
    public void testRoleSearchForMissingAttributeFailsGracefully() {
        String param = "uid=ben,ou=people,dc=springframework,dc=org";
        Set values = this.template.searchForSingleAttributeValues("ou=groups", "(member={0})", (Object[])new String[]{param}, "mail");
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void roleSearchWithEscapedCharacterSucceeds() throws Exception {
        String param = "cn=mouse\\, jerry,ou=people,dc=springframework,dc=org";
        Set values = this.template.searchForSingleAttributeValues("ou=groups", "(member={0})", (Object[])new String[]{param}, "cn");
        Assert.assertEquals((long)1L, (long)values.size());
    }

    @Test
    public void nonSpringLdapSearchCodeTestMethod() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:53389");
        env.put("java.naming.security.principal", "");
        env.put("java.naming.security.credentials", "");
        InitialDirContext ctx = new InitialDirContext(env);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningObjFlag(true);
        controls.setReturningAttributes(null);
        String param = "cn=mouse\\, jerry,ou=people,dc=springframework,dc=org";
        NamingEnumeration<SearchResult> results = ctx.search("ou=groups,dc=springframework,dc=org", "(member={0})", (Object[])new String[]{param}, controls);
        Assert.assertTrue((String)"Expected a result", (boolean)results.hasMore());
    }

    @Test
    public void searchForSingleEntryWithEscapedCharsInDnSucceeds() {
        String param = "mouse, jerry";
        DirContextOperations jerry = this.template.searchForSingleEntry("ou=people", "(cn={0})", (Object[])new String[]{param});
    }
}

