/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.MessageSource;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.DefaultInitialDirContextFactory;
import org.springframework.security.ldap.LdapUtils;

public class DefaultInitialDirContextFactoryTests
extends AbstractLdapIntegrationTests {
    DefaultInitialDirContextFactory idf;

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.idf = this.getInitialDirContextFactory();
        this.idf.setMessageSource((MessageSource)new SpringSecurityMessageSource());
    }

    @Test
    public void testAnonymousBindSucceeds() throws Exception {
        DirContext ctx = this.idf.newInitialDirContext();
        ctx.close();
    }

    @Test
    public void testBaseDnIsParsedFromCorrectlyFromUrl() {
        this.idf = new DefaultInitialDirContextFactory("ldap://springsecurity.org/dc=springframework,dc=org");
        Assert.assertEquals((Object)"dc=springframework,dc=org", (Object)this.idf.getRootDn());
        this.idf = new DefaultInitialDirContextFactory("ldap://springsecurity.org/");
        Assert.assertEquals((Object)"", (Object)this.idf.getRootDn());
        this.idf = new DefaultInitialDirContextFactory("ldap://springsecurity.org");
        Assert.assertEquals((Object)"", (Object)this.idf.getRootDn());
    }

    @Test
    public void testBindAsManagerFailsIfNoPasswordSet() throws Exception {
        this.idf.setManagerDn("uid=bob,ou=people,dc=springframework,dc=org");
        DirContext ctx = null;
        try {
            ctx = this.idf.newInitialDirContext();
            Assert.fail((String)"Binding with no manager password should fail.");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
        LdapUtils.closeContext((Context)ctx);
    }

    @Test
    public void testBindAsManagerSucceeds() throws Exception {
        this.idf.setManagerPassword("bobspassword");
        this.idf.setManagerDn("uid=bob,ou=people,dc=springframework,dc=org");
        DirContext ctx = this.idf.newInitialDirContext();
        ctx.close();
    }

    @Test
    public void testConnectionAsSpecificUserSucceeds() throws Exception {
        DirContext ctx = this.idf.newInitialDirContext("uid=Bob,ou=people,dc=springframework,dc=org", "bobspassword");
        ctx.close();
    }

    @Test
    public void testConnectionFailure() throws Exception {
        this.idf = new DefaultInitialDirContextFactory("ldap://localhost:60389");
        this.idf.setInitialContextFactory("com.sun.jndi.ldap.LdapCtxFactory");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("com.sun.jndi.ldap.connect.timeout", "200");
        this.idf.setExtraEnvVars(env);
        this.idf.setUseConnectionPool(false);
        try {
            this.idf.newInitialDirContext();
            Assert.fail((String)"Connection succeeded unexpectedly");
        }
        catch (UncategorizedLdapException uncategorizedLdapException) {
            // empty catch block
        }
    }

    @Test
    public void testEnvironment() {
        this.idf = new DefaultInitialDirContextFactory("ldap://springsecurity.org/");
        Hashtable env = this.idf.getEnvironment();
        Assert.assertEquals((Object)"ldap://springsecurity.org/", env.get("java.naming.provider.url"));
        Assert.assertEquals((Object)"simple", env.get("java.naming.security.authentication"));
        Assert.assertNull(env.get("java.naming.security.principal"));
        Assert.assertNull(env.get("java.naming.security.credentials"));
        this.idf.setInitialContextFactory("org.springframework.security.NonExistentCtxFactory");
        env = this.idf.getEnvironment();
        Assert.assertEquals((Object)"org.springframework.security.NonExistentCtxFactory", env.get("java.naming.factory.initial"));
        this.idf.setAuthenticationType("myauthtype");
        env = this.idf.getEnvironment();
        Assert.assertEquals((Object)"myauthtype", env.get("java.naming.security.authentication"));
        Hashtable<String, String> extraVars = new Hashtable<String, String>();
        extraVars.put("extravar", "extravarvalue");
        this.idf.setExtraEnvVars(extraVars);
        env = this.idf.getEnvironment();
        Assert.assertEquals((Object)"extravarvalue", env.get("extravar"));
    }

    @Test
    public void testInvalidPasswordCausesBadCredentialsException() throws Exception {
        this.idf.setManagerDn("uid=bob,ou=people,dc=springframework,dc=org");
        this.idf.setManagerPassword("wrongpassword");
        DirContext ctx = null;
        try {
            ctx = this.idf.newInitialDirContext();
            Assert.fail((String)"Binding with wrong credentials should fail.");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
        LdapUtils.closeContext((Context)ctx);
    }

    @Test
    public void testMultipleProviderUrlsAreAccepted() {
        this.idf = new DefaultInitialDirContextFactory("ldaps://security.org/dc=springframework,dc=org ldap://monkeymachine.co.uk/dc=springframework,dc=org");
    }

    @Test
    public void testMultipleProviderUrlsWithDifferentRootsAreRejected() {
        try {
            this.idf = new DefaultInitialDirContextFactory("ldap://security.org/dc=springframework,dc=org ldap://monkeymachine.co.uk/dc=someotherplace,dc=org");
            Assert.fail((String)"Different root DNs should cause an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSecureLdapUrlIsSupported() {
        this.idf = new DefaultInitialDirContextFactory("ldaps://localhost/dc=springframework,dc=org");
        Assert.assertEquals((Object)"dc=springframework,dc=org", (Object)this.idf.getRootDn());
    }

    @Test
    public void testServiceLocationUrlIsSupported() {
        this.idf = new DefaultInitialDirContextFactory("ldap:///dc=springframework,dc=org");
        Assert.assertEquals((Object)"dc=springframework,dc=org", (Object)this.idf.getRootDn());
    }
}

