/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.AccessDecisionManager;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.MockAccessDecisionManager;
import org.springframework.security.MockApplicationEventPublisher;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.MockRunAsManager;
import org.springframework.security.RunAsManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterSecurityInterceptor;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.RegexUrlPathMatcher;
import org.springframework.security.util.UrlMatcher;

public class FilterSecurityInterceptorTests
extends TestCase {
    public FilterSecurityInterceptorTests() {
    }

    public FilterSecurityInterceptorTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testEnsuresAccessDecisionManagerSupportsFilterInvocationClass() throws Exception {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)new DefaultFilterInvocationDefinitionSource((UrlMatcher)new RegexUrlPathMatcher()));
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.setAccessDecisionManager(new AccessDecisionManager(){

            public boolean supports(Class clazz) {
                return false;
            }

            public boolean supports(ConfigAttribute attribute) {
                return true;
            }

            public void decide(Authentication authentication, Object object, ConfigAttributeDefinition config) throws AccessDeniedException {
                throw new UnsupportedOperationException("mock method not implemented");
            }
        });
        try {
            interceptor.afterPropertiesSet();
            FilterSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterSecurityInterceptorTests.assertEquals((String)"AccessDecisionManager does not support secure object class: class org.springframework.security.intercept.web.FilterInvocation", (String)expected.getMessage());
        }
    }

    public void testEnsuresRunAsManagerSupportsFilterInvocationClass() throws Exception {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)new DefaultFilterInvocationDefinitionSource((UrlMatcher)new RegexUrlPathMatcher()));
        interceptor.setRunAsManager(new RunAsManager(){

            public boolean supports(Class clazz) {
                return false;
            }

            public boolean supports(ConfigAttribute attribute) {
                return true;
            }

            public Authentication buildRunAs(Authentication authentication, Object object, ConfigAttributeDefinition config) {
                throw new UnsupportedOperationException("mock method not implemented");
            }
        });
        try {
            interceptor.afterPropertiesSet();
            FilterSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterSecurityInterceptorTests.assertEquals((String)"RunAsManager does not support secure object class: class org.springframework.security.intercept.web.FilterInvocation", (String)expected.getMessage());
        }
    }

    public void testHttpsInvocationReflectsPortNumber() throws Throwable {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("MOCK_OK");
        MockFilterInvocationDefinitionMap mockSource = new MockFilterInvocationDefinitionMap("/secure/page.html", def);
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)mockSource);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setScheme("https");
        request.setServerPort(443);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_OK")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        interceptor.invoke(fi);
    }

    public void testNormalStartupAndGetter() throws Exception {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        DefaultFilterInvocationDefinitionSource fidp = new DefaultFilterInvocationDefinitionSource((UrlMatcher)new RegexUrlPathMatcher());
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)fidp);
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.afterPropertiesSet();
        FilterSecurityInterceptorTests.assertTrue((boolean)true);
        FilterSecurityInterceptorTests.assertEquals((Object)fidp, (Object)interceptor.getObjectDefinitionSource());
    }

    public void testSuccessfulInvocation() throws Throwable {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("MOCK_OK");
        MockFilterInvocationDefinitionMap mockSource = new MockFilterInvocationDefinitionMap("/secure/page.html", def);
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)mockSource);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_OK")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        interceptor.invoke(fi);
    }

    public void testNotLoadedFromApplicationContext() throws Exception {
        LinkedHashMap<RequestKey, ConfigAttributeDefinition> reqMap = new LinkedHashMap<RequestKey, ConfigAttributeDefinition>();
        reqMap.put(new RequestKey("/secure/**", null), new ConfigAttributeDefinition(new String[]{"ROLE_USER"}));
        DefaultFilterInvocationDefinitionSource fids = new DefaultFilterInvocationDefinitionSource((UrlMatcher)new AntUrlPathMatcher());
        FilterSecurityInterceptor filter = new FilterSecurityInterceptor();
        filter.setObjectDefinitionSource((FilterInvocationDefinitionSource)fids);
        MockFilterChain filterChain = new MockFilterChain();
        filterChain.expectToProceed = true;
        FilterInvocation fi = new FilterInvocation((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)filterChain);
        filter.invoke(fi);
    }

    private class MockFilterInvocationDefinitionMap
    implements FilterInvocationDefinitionSource {
        private ConfigAttributeDefinition toReturn;
        private String servletPath;

        public MockFilterInvocationDefinitionMap(String servletPath, ConfigAttributeDefinition toReturn) {
            this.servletPath = servletPath;
            this.toReturn = toReturn;
        }

        public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
            FilterInvocation fi = (FilterInvocation)object;
            if (this.servletPath.equals(fi.getHttpRequest().getServletPath())) {
                return this.toReturn;
            }
            return null;
        }

        public Collection getConfigAttributeDefinitions() {
            return null;
        }

        public boolean supports(Class clazz) {
            return true;
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

