/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method.aopalliance;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.TargetObject;
import org.springframework.security.intercept.method.MapBasedMethodDefinitionSource;
import org.springframework.security.intercept.method.MethodDefinitionSource;
import org.springframework.security.intercept.method.MethodDefinitionSourceEditor;
import org.springframework.security.intercept.method.aopalliance.MethodDefinitionSourceAdvisor;
import org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor;

public class MethodDefinitionSourceAdvisorTests
extends TestCase {
    public MethodDefinitionSourceAdvisorTests() {
    }

    public MethodDefinitionSourceAdvisorTests(String arg0) {
        super(arg0);
    }

    private MethodSecurityInterceptor getInterceptor() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.springframework.security.TargetObject.countLength=ROLE_NOT_USED");
        MapBasedMethodDefinitionSource map = (MapBasedMethodDefinitionSource)editor.getValue();
        MethodSecurityInterceptor msi = new MethodSecurityInterceptor();
        msi.setObjectDefinitionSource((MethodDefinitionSource)map);
        return msi;
    }

    public static void main(String[] args) {
        TestRunner.run(MethodDefinitionSourceAdvisorTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAdvisorReturnsFalseWhenMethodInvocationNotDefined() throws Exception {
        Class<TargetObject> clazz = TargetObject.class;
        Method method = clazz.getMethod("makeLowerCase", String.class);
        MethodDefinitionSourceAdvisor advisor = new MethodDefinitionSourceAdvisor(this.getInterceptor());
        MethodDefinitionSourceAdvisorTests.assertFalse((boolean)advisor.getPointcut().getMethodMatcher().matches(method, clazz));
    }

    public void testAdvisorReturnsTrueWhenMethodInvocationIsDefined() throws Exception {
        Class<TargetObject> clazz = TargetObject.class;
        Method method = clazz.getMethod("countLength", String.class);
        MethodDefinitionSourceAdvisor advisor = new MethodDefinitionSourceAdvisor(this.getInterceptor());
        MethodDefinitionSourceAdvisorTests.assertTrue((boolean)advisor.getPointcut().getMethodMatcher().matches(method, clazz));
    }

    public void testDetectsImproperlyConfiguredAdvice() {
        MethodSecurityInterceptor msi = new MethodSecurityInterceptor();
        try {
            new MethodDefinitionSourceAdvisor(msi);
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have detected null ObjectDefinitionSource and thrown AopConfigException");
        }
        catch (IllegalArgumentException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
    }

    public void testUnsupportedOperations() throws Throwable {
        Class<TargetObject> clazz = TargetObject.class;
        Method method = clazz.getMethod("countLength", String.class);
        MethodDefinitionSourceAdvisor methodDefinitionSourceAdvisor = new MethodDefinitionSourceAdvisor(this.getInterceptor());
        methodDefinitionSourceAdvisor.getClass();
        MethodDefinitionSourceAdvisor.InternalMethodInvocation imi = new MethodDefinitionSourceAdvisor.InternalMethodInvocation(methodDefinitionSourceAdvisor, method, clazz);
        try {
            imi.getArguments();
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
        try {
            imi.getStaticPart();
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
        try {
            imi.proceed();
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
        try {
            new MethodDefinitionSourceAdvisor.InternalMethodInvocation(new MethodDefinitionSourceAdvisor(this.getInterceptor()));
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
    }
}

