/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.config.CachingUserDetailsService;
import org.springframework.security.providers.ProviderManager;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.dao.DaoAuthenticationProvider;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.jdbc.JdbcUserDetailsManager;
import org.springframework.security.util.AuthorityUtils;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class JdbcUserServiceBeanDefinitionParserTests {
    private static String USER_CACHE_XML = "<b:bean id='userCache' class='org.springframework.security.providers.dao.MockUserCache'/>";
    private static String DATA_SOURCE = "    <b:bean id='populator' class='org.springframework.security.config.DataSourcePopulator'>        <b:property name='dataSource' ref='dataSource'/>    </b:bean>    <b:bean id='dataSource' class='org.springframework.security.TestDataSource'>        <b:constructor-arg value='jdbcnamespaces'/>    </b:bean>";
    private InMemoryXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
        }
    }

    @Test
    public void validUsernameIsFound() {
        this.setContext("<jdbc-user-service data-source-ref='dataSource'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("_userDetailsService");
        Assert.assertTrue((mgr.loadUserByUsername("rod") != null ? 1 : 0) != 0);
    }

    @Test
    public void beanIdIsParsedCorrectly() {
        this.setContext("<jdbc-user-service id='myUserService' data-source-ref='dataSource'/>" + DATA_SOURCE);
        Assert.assertTrue((boolean)(this.appContext.getBean("myUserService") instanceof JdbcUserDetailsManager));
    }

    @Test
    public void usernameAndAuthorityQueriesAreParsedCorrectly() throws Exception {
        String userQuery = "select username, password, true from users where username = ?";
        String authoritiesQuery = "select username, authority from authorities where username = ? and 1 = 1";
        this.setContext("<jdbc-user-service id='myUserService' data-source-ref='dataSource' users-by-username-query='" + userQuery + "' " + "authorities-by-username-query='" + authoritiesQuery + "'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("myUserService");
        Assert.assertEquals((Object)userQuery, (Object)FieldUtils.getFieldValue((Object)mgr, (String)"usersByUsernameQuery"));
        Assert.assertEquals((Object)authoritiesQuery, (Object)FieldUtils.getFieldValue((Object)mgr, (String)"authoritiesByUsernameQuery"));
        Assert.assertTrue((mgr.loadUserByUsername("rod") != null ? 1 : 0) != 0);
    }

    @Test
    public void groupQueryIsParsedCorrectly() throws Exception {
        this.setContext("<jdbc-user-service id='myUserService' data-source-ref='dataSource' group-authorities-by-username-query='blah blah'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("myUserService");
        Assert.assertEquals((Object)"blah blah", (Object)FieldUtils.getFieldValue((Object)mgr, (String)"groupAuthoritiesByUsernameQuery"));
        Assert.assertTrue((boolean)((Boolean)FieldUtils.getFieldValue((Object)mgr, (String)"enableGroups")));
    }

    @Test
    public void cacheRefIsparsedCorrectly() {
        this.setContext("<jdbc-user-service id='myUserService' cache-ref='userCache' data-source-ref='dataSource'/>" + DATA_SOURCE + USER_CACHE_XML);
        CachingUserDetailsService cachingUserService = (CachingUserDetailsService)this.appContext.getBean("myUserService.caching");
        Assert.assertSame((Object)cachingUserService.getUserCache(), (Object)this.appContext.getBean("userCache"));
    }

    @Test
    public void isSupportedByAuthenticationProviderElement() {
        this.setContext("<authentication-provider>    <jdbc-user-service data-source-ref='dataSource'/></authentication-provider>" + DATA_SOURCE);
        AuthenticationManager mgr = (AuthenticationManager)this.appContext.getBean("_authenticationManager");
        mgr.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala"));
    }

    @Test
    public void cacheIsInjectedIntoAuthenticationProvider() {
        this.setContext("<authentication-provider>    <jdbc-user-service cache-ref='userCache' data-source-ref='dataSource'/></authentication-provider>" + DATA_SOURCE + USER_CACHE_XML);
        ProviderManager mgr = (ProviderManager)this.appContext.getBean("_authenticationManager");
        DaoAuthenticationProvider provider = (DaoAuthenticationProvider)mgr.getProviders().get(0);
        Assert.assertSame((Object)provider.getUserCache(), (Object)this.appContext.getBean("userCache"));
        provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala"));
        Assert.assertNotNull((String)"Cache should contain user after authentication", (Object)provider.getUserCache().getUserFromCache("rod"));
    }

    @Test
    public void rolePrefixIsUsedWhenSet() {
        this.setContext("<jdbc-user-service id='myUserService' role-prefix='PREFIX_' data-source-ref='dataSource'/>" + DATA_SOURCE);
        JdbcUserDetailsManager mgr = (JdbcUserDetailsManager)this.appContext.getBean("myUserService");
        UserDetails rod = mgr.loadUserByUsername("rod");
        Assert.assertTrue((boolean)AuthorityUtils.authorityArrayToSet((GrantedAuthority[])rod.getAuthorities()).contains("PREFIX_ROLE_SUPERVISOR"));
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }
}

