/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockAuthenticationEntryPoint;
import org.springframework.security.MockFilterChain;
import org.springframework.security.SecurityConfig;
import org.springframework.security.concurrent.ConcurrentLoginException;
import org.springframework.security.concurrent.ConcurrentSessionControllerImpl;
import org.springframework.security.concurrent.ConcurrentSessionFilter;
import org.springframework.security.config.PostProcessedMockUserDetailsService;
import org.springframework.security.context.HttpSessionContextIntegrationFilter;
import org.springframework.security.firewall.DefaultHttpFirewall;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.FilterSecurityInterceptor;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousProcessingFilter;
import org.springframework.security.securechannel.ChannelProcessingFilter;
import org.springframework.security.ui.ExceptionTranslationFilter;
import org.springframework.security.ui.SessionFixationProtectionFilter;
import org.springframework.security.ui.WebAuthenticationDetails;
import org.springframework.security.ui.basicauth.BasicProcessingFilter;
import org.springframework.security.ui.logout.LogoutFilter;
import org.springframework.security.ui.logout.LogoutHandler;
import org.springframework.security.ui.preauth.x509.X509PreAuthenticatedProcessingFilter;
import org.springframework.security.ui.rememberme.NullRememberMeServices;
import org.springframework.security.ui.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.ui.rememberme.RememberMeProcessingFilter;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;
import org.springframework.security.ui.webapp.DefaultLoginPageGeneratingFilter;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.util.FilterChainProxy;
import org.springframework.security.util.InMemoryXmlApplicationContext;
import org.springframework.security.util.MockFilter;
import org.springframework.security.util.PortMapperImpl;
import org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter;
import org.springframework.util.ReflectionUtils;

public class HttpSecurityBeanDefinitionParserTests {
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
    }

    @Test
    public void minimalConfigurationParses() {
        this.setContext("<http><http-basic /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test
    public void httpAutoConfigSetsUpCorrectFilterList() throws Exception {
        this.setContext("<http auto-config='true' />    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filterList = this.getFilters("/anyurl");
        this.checkAutoConfigFilters(filterList);
        Assert.assertEquals((Object)true, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_filterChainProxy"), (String)"stripQueryStringFromUrls"));
        Assert.assertEquals((Object)true, (Object)FieldUtils.getFieldValue(filterList.get(10), (String)"objectDefinitionSource.stripQueryStringFromUrls"));
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void duplicateElementCausesError() throws Exception {
        this.setContext("<http auto-config='true' /><http auto-config='true' />    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    private void checkAutoConfigFilters(List filterList) throws Exception {
        Assert.assertEquals((String)"Expected 11 filters in chain", (long)11L, (long)filterList.size());
        Iterator filters = filterList.iterator();
        Assert.assertTrue((boolean)(filters.next() instanceof HttpSessionContextIntegrationFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof LogoutFilter));
        Object authProcFilter = filters.next();
        Assert.assertTrue((boolean)(authProcFilter instanceof AuthenticationProcessingFilter));
        Object rms = FieldUtils.getFieldValue(authProcFilter, (String)"rememberMeServices");
        Assert.assertNotNull((Object)rms);
        Assert.assertTrue((boolean)(rms instanceof RememberMeServices));
        Assert.assertFalse((boolean)(rms instanceof NullRememberMeServices));
        Assert.assertTrue((boolean)(filters.next() instanceof DefaultLoginPageGeneratingFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof BasicProcessingFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof SecurityContextHolderAwareRequestFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof RememberMeProcessingFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof AnonymousProcessingFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof ExceptionTranslationFilter));
        Assert.assertTrue((boolean)(filters.next() instanceof SessionFixationProtectionFilter));
        Object fsiObj = filters.next();
        Assert.assertTrue((boolean)(fsiObj instanceof FilterSecurityInterceptor));
        FilterSecurityInterceptor fsi = (FilterSecurityInterceptor)fsiObj;
        Assert.assertTrue((boolean)fsi.isObserveOncePerRequest());
    }

    @Test
    public void filterListShouldBeEmptyForUnprotectedUrl() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/unprotected' filters='none' />    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filters = this.getFilters("/unprotected");
        Assert.assertTrue((filters.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void regexPathsWorkCorrectly() throws Exception {
        this.setContext("    <http auto-config='true' path-type='regex'>        <intercept-url pattern='\\A\\/[a-z]+' filters='none' />    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertEquals((long)0L, (long)this.getFilters("/imlowercase").size());
        List allFilters = this.getFilters("/ImCaughtByTheUniversalMatchPattern");
        this.checkAutoConfigFilters(allFilters);
        Assert.assertEquals((Object)false, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_filterChainProxy"), (String)"stripQueryStringFromUrls"));
        Assert.assertEquals((Object)false, (Object)FieldUtils.getFieldValue(allFilters.get(10), (String)"objectDefinitionSource.stripQueryStringFromUrls"));
    }

    @Test
    public void lowerCaseComparisonAttributeIsRespectedByFilterChainProxy() throws Exception {
        this.setContext("    <http auto-config='true' path-type='ant' lowercase-comparisons='false'>        <intercept-url pattern='/Secure*' filters='none' />    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertEquals((long)0L, (long)this.getFilters("/Secure").size());
        this.checkAutoConfigFilters(this.getFilters("/secure"));
        this.checkAutoConfigFilters(this.getFilters("/ImCaughtByTheUniversalMatchPattern"));
    }

    @Test
    public void formLoginWithNoLoginPageAddsDefaultLoginPageFilter() throws Exception {
        this.setContext("<http auto-config='true' path-type='ant' lowercase-comparisons='false'>   <form-login /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        this.checkAutoConfigFilters(this.getFilters("/anything"));
    }

    @Test
    public void formLoginAlwaysUseDefaultSetsCorrectProperty() throws Exception {
        this.setContext("<http>   <form-login default-target-url='/default' always-use-default-target='true' /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        AuthenticationProcessingFilter filter = (AuthenticationProcessingFilter)this.getFilters("/anything").get(1);
        Assert.assertEquals((Object)"/default", (Object)filter.getDefaultTargetUrl());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)filter, (String)"alwaysUseDefaultTargetUrl"));
    }

    @Test(expected=BeanCreationException.class)
    public void invalidLoginPageIsDetected() throws Exception {
        this.setContext("<http>   <form-login login-page='noLeadingSlash'/></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test(expected=BeanCreationException.class)
    public void invalidDefaultTargetUrlIsDetected() throws Exception {
        this.setContext("<http>   <form-login default-target-url='noLeadingSlash'/></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test(expected=BeanCreationException.class)
    public void invalidLogoutUrlIsDetected() throws Exception {
        this.setContext("<http>   <logout logout-url='noLeadingSlash'/>   <form-login /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test(expected=BeanCreationException.class)
    public void invalidLogoutSuccessUrlIsDetected() throws Exception {
        this.setContext("<http>   <logout logout-success-url='noLeadingSlash'/>   <form-login /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test
    public void lowerCaseComparisonIsRespectedBySecurityFilterInvocationDefinitionSource() throws Exception {
        this.setContext("    <http auto-config='true' path-type='ant' lowercase-comparisons='false'>        <intercept-url pattern='/Secure*' access='ROLE_A,ROLE_B' />        <intercept-url pattern='/**' access='ROLE_C' />    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        FilterSecurityInterceptor fis = (FilterSecurityInterceptor)this.appContext.getBean("_filterSecurityInterceptor");
        FilterInvocationDefinitionSource fids = fis.getObjectDefinitionSource();
        ConfigAttributeDefinition attrDef = fids.getAttributes((Object)this.createFilterinvocation("/Secure", null));
        Assert.assertEquals((long)2L, (long)attrDef.getConfigAttributes().size());
        Assert.assertTrue((boolean)attrDef.contains((ConfigAttribute)new SecurityConfig("ROLE_A")));
        Assert.assertTrue((boolean)attrDef.contains((ConfigAttribute)new SecurityConfig("ROLE_B")));
        attrDef = fids.getAttributes((Object)this.createFilterinvocation("/secure", null));
        Assert.assertEquals((long)1L, (long)attrDef.getConfigAttributes().size());
        Assert.assertTrue((boolean)attrDef.contains((ConfigAttribute)new SecurityConfig("ROLE_C")));
    }

    @Test
    public void httpMethodMatchIsSupported() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/**' access='ROLE_C' />        <intercept-url pattern='/secure*' method='DELETE' access='ROLE_SUPERVISOR' />        <intercept-url pattern='/secure*' method='POST' access='ROLE_A,ROLE_B' />    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        FilterSecurityInterceptor fis = (FilterSecurityInterceptor)this.appContext.getBean("_filterSecurityInterceptor");
        FilterInvocationDefinitionSource fids = fis.getObjectDefinitionSource();
        ConfigAttributeDefinition attrs = fids.getAttributes((Object)this.createFilterinvocation("/secure", "POST"));
        Assert.assertEquals((long)2L, (long)attrs.getConfigAttributes().size());
        Assert.assertTrue((boolean)attrs.contains((ConfigAttribute)new SecurityConfig("ROLE_A")));
        Assert.assertTrue((boolean)attrs.contains((ConfigAttribute)new SecurityConfig("ROLE_B")));
    }

    @Test
    public void oncePerRequestAttributeIsSupported() throws Exception {
        this.setContext("<http once-per-request='false'><http-basic /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filters = this.getFilters("/someurl");
        FilterSecurityInterceptor fsi = (FilterSecurityInterceptor)filters.get(filters.size() - 1);
        Assert.assertFalse((boolean)fsi.isObserveOncePerRequest());
    }

    @Test
    public void accessDeniedPageAttributeIsSupported() throws Exception {
        this.setContext("<http access-denied-page='/access-denied'><http-basic /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filters = this.getFilters("/someurl");
        ExceptionTranslationFilter etf = (ExceptionTranslationFilter)filters.get(filters.size() - 3);
        Assert.assertEquals((Object)"/access-denied", (Object)FieldUtils.getFieldValue((Object)etf, (String)"accessDeniedHandler.errorPage"));
    }

    @Test(expected=BeanCreationException.class)
    public void invalidAccessDeniedUrlIsDetected() throws Exception {
        this.setContext("<http auto-config='true' access-denied-page='noLeadingSlash'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test
    public void interceptUrlWithRequiresChannelAddsChannelFilterToStack() throws Exception {
        this.setContext("    <http auto-config='true'>        <intercept-url pattern='/**' requires-channel='https' />    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filters = this.getFilters("/someurl");
        Assert.assertEquals((String)"Expected 12 filters in chain", (long)12L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof ChannelProcessingFilter));
    }

    @Test
    public void portMappingsAreParsedCorrectly() throws Exception {
        this.setContext("    <http auto-config='true'>        <port-mappings>            <port-mapping http='9080' https='9443'/>        </port-mappings>    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        PortMapperImpl pm = (PortMapperImpl)this.appContext.getBean("_portMapper");
        Assert.assertEquals((long)1L, (long)pm.getTranslatedPortMappings().size());
        Assert.assertEquals((Object)9080, (Object)pm.lookupHttpPort(Integer.valueOf(9443)));
        Assert.assertEquals((Object)9443, (Object)pm.lookupHttpsPort(Integer.valueOf(9080)));
    }

    @Test
    public void portMappingsWorkWithPlaceholders() throws Exception {
        System.setProperty("http", "9080");
        System.setProperty("https", "9443");
        this.setContext("    <b:bean id='configurer' class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/>    <http auto-config='true'>        <port-mappings>            <port-mapping http='${http}' https='${https}'/>        </port-mappings>    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        PortMapperImpl pm = (PortMapperImpl)this.appContext.getBean("_portMapper");
        Assert.assertEquals((long)1L, (long)pm.getTranslatedPortMappings().size());
        Assert.assertEquals((Object)9080, (Object)pm.lookupHttpPort(Integer.valueOf(9443)));
        Assert.assertEquals((Object)9443, (Object)pm.lookupHttpsPort(Integer.valueOf(9080)));
    }

    @Test
    public void accessDeniedPageWorkWithPlaceholders() throws Exception {
        System.setProperty("accessDenied", "/go-away");
        this.setContext("    <b:bean id='configurer' class='org.springframework.beans.factory.config.PropertyPlaceholderConfigurer'/>    <http auto-config='true' access-denied-page='${accessDenied}'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        ExceptionTranslationFilter filter = (ExceptionTranslationFilter)this.appContext.getBean("_exceptionTranslationFilter");
        Assert.assertEquals((Object)"/go-away", (Object)FieldUtils.getFieldValue((Object)filter, (String)"accessDeniedHandler.errorPage"));
    }

    @Test
    public void externalFiltersAreTreatedCorrectly() throws Exception {
        this.setContext("<http auto-config='true'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider><b:bean id='userFilter' class='org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter'>    <custom-filter after='LOGOUT_FILTER'/></b:bean><b:bean id='userFilter1' class='org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter'>    <custom-filter before='SESSION_CONTEXT_INTEGRATION_FILTER'/></b:bean><b:bean id='userFilter2' class='org.springframework.security.util.MockFilter'>    <custom-filter position='FIRST'/></b:bean><b:bean id='userFilter3' class='org.springframework.security.util.MockFilter'/><b:bean id='userFilter4' class='org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter'/>");
        List filters = this.getFilters("/someurl");
        Assert.assertEquals((long)14L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof MockFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof SecurityContextHolderAwareRequestFilter));
        Assert.assertTrue((boolean)(filters.get(4) instanceof SecurityContextHolderAwareRequestFilter));
    }

    @Test(expected=BeanCreationException.class)
    public void twoFiltersWithSameOrderAreRejected() {
        this.setContext("<http auto-config='true'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider><b:bean id='userFilter' class='org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter'>    <custom-filter position='LOGOUT_FILTER'/></b:bean>");
    }

    @Test
    public void rememberMeServiceWorksWithTokenRepoRef() {
        this.setContext("<http auto-config='true'>    <remember-me token-repository-ref='tokenRepo'/></http><b:bean id='tokenRepo' class='org.springframework.security.ui.rememberme.InMemoryTokenRepositoryImpl'/>     <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Object rememberMeServices = this.appContext.getBean("_rememberMeServices");
        Assert.assertTrue((boolean)(rememberMeServices instanceof PersistentTokenBasedRememberMeServices));
    }

    @Test
    public void rememberMeServiceWorksWithDataSourceRef() {
        this.setContext("<http auto-config='true'>    <remember-me data-source-ref='ds'/></http><b:bean id='ds' class='org.springframework.security.TestDataSource'>     <b:constructor-arg value='tokendb'/></b:bean>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Object rememberMeServices = this.appContext.getBean("_rememberMeServices");
        Assert.assertTrue((boolean)(rememberMeServices instanceof PersistentTokenBasedRememberMeServices));
    }

    @Test
    public void rememberMeServiceWorksWithExternalServicesImpl() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me key='ourkey' services-ref='rms'/></http><b:bean id='rms' class='org.springframework.security.ui.rememberme.TokenBasedRememberMeServices'>     <b:property name='userDetailsService' ref='us'/>    <b:property name='key' value='ourkey'/>    <b:property name='tokenValiditySeconds' value='5000'/></b:bean>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertEquals((Object)5000, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_rememberMeServices"), (String)"tokenValiditySeconds"));
        LogoutHandler[] logoutHandlers = (LogoutHandler[])FieldUtils.getFieldValue((Object)this.appContext.getBean("_logoutFilter"), (String)"handlers");
        Assert.assertEquals((long)2L, (long)logoutHandlers.length);
        Assert.assertEquals((Object)this.appContext.getBean("_rememberMeServices"), (Object)logoutHandlers[1]);
    }

    @Test
    public void rememberMeTokenValidityIsParsedCorrectly() throws Exception {
        this.setContext("<http auto-config='true'>    <remember-me key='ourkey' token-validity-seconds='10000' /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertEquals((Object)10000, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_rememberMeServices"), (String)"tokenValiditySeconds"));
    }

    @Test
    public void rememberMeServiceConfigurationParsesWithCustomUserService() {
        this.setContext("<http auto-config='true'>    <remember-me key='somekey' user-service-ref='userService'/></http><b:bean id='userService' class='org.springframework.security.userdetails.MockUserDetailsService'/>     <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test
    public void x509SupportAddsFilterAtExpectedPosition() throws Exception {
        this.setContext("<http auto-config='true'>    <x509 /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filters = this.getFilters("/someurl");
        Assert.assertTrue((boolean)(filters.get(2) instanceof X509PreAuthenticatedProcessingFilter));
    }

    @Test
    public void concurrentSessionSupportAddsFilterAndExpectedBeans() throws Exception {
        this.setContext("<http auto-config='true'>    <concurrent-session-control session-registry-alias='seshRegistry' expired-url='/expired'/></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filters = this.getFilters("/someurl");
        Assert.assertTrue((boolean)(filters.get(0) instanceof ConcurrentSessionFilter));
        Assert.assertNotNull((Object)this.appContext.getBean("seshRegistry"));
        Assert.assertNotNull((Object)this.appContext.getBean("_concurrentSessionController"));
    }

    @Test
    public void externalSessionRegistryBeanIsConfiguredCorrectly() throws Exception {
        this.setContext("<http auto-config='true'>    <concurrent-session-control session-registry-ref='seshRegistry' /></http><b:bean id='seshRegistry' class='org.springframework.security.concurrent.SessionRegistryImpl'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Object sessionRegistry = this.appContext.getBean("seshRegistry");
        Object sessionRegistryFromFilter = FieldUtils.getFieldValue((Object)this.appContext.getBean("_concurrentSessionFilter"), (String)"sessionRegistry");
        Object sessionRegistryFromController = FieldUtils.getFieldValue((Object)this.appContext.getBean("_concurrentSessionController"), (String)"sessionRegistry");
        Object sessionRegistryFromFixationFilter = FieldUtils.getFieldValue((Object)this.appContext.getBean("_sessionFixationProtectionFilter"), (String)"sessionRegistry");
        Assert.assertSame((Object)sessionRegistry, (Object)sessionRegistryFromFilter);
        Assert.assertSame((Object)sessionRegistry, (Object)sessionRegistryFromController);
        Assert.assertSame((Object)sessionRegistry, (Object)sessionRegistryFromFixationFilter);
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void concurrentSessionSupportCantBeUsedWithIndependentControllerBean() throws Exception {
        this.setContext("<authentication-manager alias='authManager' session-controller-ref='sc'/><http auto-config='true'>    <concurrent-session-control session-registry-alias='seshRegistry' expired-url='/expired'/></http><b:bean id='sc' class='org.springframework.security.concurrent.ConcurrentSessionControllerImpl'>  <b:property name='sessionRegistry'>    <b:bean class='org.springframework.security.concurrent.SessionRegistryImpl'/>  </b:property></b:bean>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test(expected=BeanDefinitionParsingException.class)
    public void concurrentSessionSupportCantBeUsedWithIndependentControllerBean2() throws Exception {
        this.setContext("<http auto-config='true'>    <concurrent-session-control session-registry-alias='seshRegistry' expired-url='/expired'/></http><b:bean id='sc' class='org.springframework.security.concurrent.ConcurrentSessionControllerImpl'>  <b:property name='sessionRegistry'>    <b:bean class='org.springframework.security.concurrent.SessionRegistryImpl'/>  </b:property></b:bean><authentication-manager alias='authManager' session-controller-ref='sc'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test(expected=ConcurrentLoginException.class)
    public void concurrentSessionMaxSessionsIsCorrectlyConfigured() throws Exception {
        this.setContext("<http auto-config='true'>    <concurrent-session-control max-sessions='2' exception-if-maximum-exceeded='true' /></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        ConcurrentSessionControllerImpl seshController = (ConcurrentSessionControllerImpl)this.appContext.getBean("_concurrentSessionController");
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"pass");
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setSession((HttpSession)new MockHttpSession());
        auth.setDetails((Object)new WebAuthenticationDetails((HttpServletRequest)req));
        try {
            seshController.checkAuthenticationAllowed((Authentication)auth);
        }
        catch (ConcurrentLoginException e) {
            Assert.fail((String)"First login should be allowed");
        }
        seshController.registerSuccessfulAuthentication((Authentication)auth);
        req.setSession((HttpSession)new MockHttpSession());
        try {
            seshController.checkAuthenticationAllowed((Authentication)auth);
        }
        catch (ConcurrentLoginException e) {
            Assert.fail((String)"Second login should be allowed");
        }
        auth.setDetails((Object)new WebAuthenticationDetails((HttpServletRequest)req));
        seshController.registerSuccessfulAuthentication((Authentication)auth);
        req.setSession((HttpSession)new MockHttpSession());
        auth.setDetails((Object)new WebAuthenticationDetails((HttpServletRequest)req));
        seshController.checkAuthenticationAllowed((Authentication)auth);
    }

    @Test
    public void customEntryPointIsSupported() throws Exception {
        this.setContext("<http auto-config='true' entry-point-ref='entryPoint'/><b:bean id='entryPoint' class='org.springframework.security.MockAuthenticationEntryPoint'>    <b:constructor-arg value='/customlogin'/></b:bean>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        ExceptionTranslationFilter etf = (ExceptionTranslationFilter)this.getFilters("/someurl").get(8);
        Assert.assertTrue((String)"ExceptionTranslationFilter should be configured with custom entry point", (boolean)(etf.getAuthenticationEntryPoint() instanceof MockAuthenticationEntryPoint));
    }

    @Test
    public void rememberMeServicesWorksWithoutBasicProcessingFilter() {
        this.setContext("    <http>        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>        <logout logout-success-url='/login.jsp'/>        <anonymous username='guest' granted-authority='guest'/>        <remember-me />    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test
    public void disablingSessionProtectionRemovesFilter() throws Exception {
        this.setContext("<http auto-config='true' session-fixation-protection='none'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        List filters = this.getFilters("/someurl");
        Assert.assertFalse((boolean)(filters.get(1) instanceof SessionFixationProtectionFilter));
    }

    @Test
    public void httpElementDoesntInterfereWithBeanPostProcessing() {
        this.setContext("<http auto-config='true'/><authentication-provider user-service-ref='myUserService'/><b:bean id='myUserService' class='org.springframework.security.config.PostProcessedMockUserDetailsService'/><b:bean id='beanPostProcessor' class='org.springframework.security.config.MockUserServiceBeanPostProcessor'/>");
        PostProcessedMockUserDetailsService service = (PostProcessedMockUserDetailsService)this.appContext.getBean("myUserService");
        Assert.assertEquals((Object)"Hello from the post processor!", (Object)service.getPostProcessorWasHere());
    }

    @Test
    public void unprotectedLoginPageDoesntResultInWarning() {
        this.setContext("    <http>        <intercept-url pattern='/login.jsp*' access='IS_AUTHENTICATED_ANONYMOUSLY'/>        <intercept-url pattern='/**' access='ROLE_A'/>        <anonymous />        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        this.closeAppContext();
        this.setContext("    <http>        <intercept-url pattern='/login.jsp*' filters='none'/>        <intercept-url pattern='/**' access='ROLE_A'/>        <anonymous />        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test
    public void protectedLoginPageResultsInWarning() {
        this.setContext("    <http>        <intercept-url pattern='/**' access='ROLE_A'/>        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        this.closeAppContext();
        this.setContext("    <http>        <intercept-url pattern='/**' access='ROLE_A'/>        <anonymous />        <form-login login-page='/login.jsp' default-target-url='/messageList.html'/>    </http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
    }

    @Test
    public void settingCreateSessionToAlwaysSetsFilterPropertiesCorrectly() throws Exception {
        this.setContext("<http auto-config='true' create-session='always'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_httpSessionContextIntegrationFilter"), (String)"forceEagerSessionCreation"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_httpSessionContextIntegrationFilter"), (String)"allowSessionCreation"));
    }

    @Test
    public void settingCreateSessionToNeverSetsFilterPropertiesCorrectly() throws Exception {
        this.setContext("<http auto-config='true' create-session='never'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_httpSessionContextIntegrationFilter"), (String)"forceEagerSessionCreation"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_httpSessionContextIntegrationFilter"), (String)"allowSessionCreation"));
    }

    @Test
    public void supportsTwoIdenticalInterceptUrls() {
        this.setContext("<http auto-config='true'>    <intercept-url pattern='/someurl' access='ROLE_A'/>    <intercept-url pattern='/someurl' access='ROLE_B'/></http>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        FilterSecurityInterceptor fis = (FilterSecurityInterceptor)this.appContext.getBean("_filterSecurityInterceptor");
        FilterInvocationDefinitionSource fids = fis.getObjectDefinitionSource();
        ConfigAttributeDefinition attrDef = fids.getAttributes((Object)this.createFilterinvocation("/someurl", null));
        Assert.assertEquals((long)1L, (long)attrDef.getConfigAttributes().size());
        Assert.assertTrue((boolean)attrDef.contains((ConfigAttribute)new SecurityConfig("ROLE_B")));
    }

    @Test
    public void httpFirewallInjectionIsSupported() throws Exception {
        this.setContext("<http-firewall ref='fw'/><http>   <form-login /></http><b:bean id='fw' class='" + DefaultHttpFirewall.class.getName() + "'/>" + "    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("_filterChainProxy");
        Assert.assertSame((Object)this.appContext.getBean("fw"), (Object)FieldUtils.getFieldValue((Object)fcp, (String)"firewall"));
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }

    private List getFilters(String url) throws Exception {
        FilterChainProxy fcp = (FilterChainProxy)this.appContext.getBean("_filterChainProxy");
        Method getFilters = fcp.getClass().getDeclaredMethod("getFilters", String.class);
        getFilters.setAccessible(true);
        return (List)ReflectionUtils.invokeMethod((Method)getFilters, (Object)fcp, (Object[])new Object[]{url});
    }

    private FilterInvocation createFilterinvocation(String path, String method) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(method);
        request.setRequestURI(null);
        request.setServletPath(path);
        return new FilterInvocation((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }
}

