/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authoritymapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.authoritymapping.SimpleAttributes2GrantedAuthoritiesMapper;

public class SimpleRoles2GrantedAuthoritiesMapperTests
extends TestCase {
    public final void testAfterPropertiesSetConvertToUpperAndLowerCase() {
        SimpleAttributes2GrantedAuthoritiesMapper mapper = new SimpleAttributes2GrantedAuthoritiesMapper();
        mapper.setConvertAttributeToLowerCase(true);
        mapper.setConvertAttributeToUpperCase(true);
        try {
            mapper.afterPropertiesSet();
            SimpleRoles2GrantedAuthoritiesMapperTests.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            SimpleRoles2GrantedAuthoritiesMapperTests.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testAfterPropertiesSet() {
        SimpleAttributes2GrantedAuthoritiesMapper mapper = new SimpleAttributes2GrantedAuthoritiesMapper();
        try {
            mapper.afterPropertiesSet();
        }
        catch (Exception unexpected) {
            SimpleRoles2GrantedAuthoritiesMapperTests.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testGetGrantedAuthoritiesNoConversion() {
        String[] roles = new String[]{"Role1", "Role2"};
        String[] expectedGas = new String[]{"Role1", "Role2"};
        SimpleAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities(mapper, roles, expectedGas);
    }

    public final void testGetGrantedAuthoritiesToUpperCase() {
        String[] roles = new String[]{"Role1", "Role2"};
        String[] expectedGas = new String[]{"ROLE1", "ROLE2"};
        SimpleAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        mapper.setConvertAttributeToUpperCase(true);
        this.testGetGrantedAuthorities(mapper, roles, expectedGas);
    }

    public final void testGetGrantedAuthoritiesToLowerCase() {
        String[] roles = new String[]{"Role1", "Role2"};
        String[] expectedGas = new String[]{"role1", "role2"};
        SimpleAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        mapper.setConvertAttributeToLowerCase(true);
        this.testGetGrantedAuthorities(mapper, roles, expectedGas);
    }

    public final void testGetGrantedAuthoritiesAddPrefixIfAlreadyExisting() {
        String[] roles = new String[]{"Role1", "Role2", "ROLE_Role3"};
        String[] expectedGas = new String[]{"ROLE_Role1", "ROLE_Role2", "ROLE_ROLE_Role3"};
        SimpleAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        mapper.setAddPrefixIfAlreadyExisting(true);
        mapper.setAttributePrefix("ROLE_");
        this.testGetGrantedAuthorities(mapper, roles, expectedGas);
    }

    public final void testGetGrantedAuthoritiesDontAddPrefixIfAlreadyExisting1() {
        String[] roles = new String[]{"Role1", "Role2", "ROLE_Role3"};
        String[] expectedGas = new String[]{"ROLE_Role1", "ROLE_Role2", "ROLE_Role3"};
        SimpleAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        mapper.setAddPrefixIfAlreadyExisting(false);
        mapper.setAttributePrefix("ROLE_");
        this.testGetGrantedAuthorities(mapper, roles, expectedGas);
    }

    public final void testGetGrantedAuthoritiesDontAddPrefixIfAlreadyExisting2() {
        String[] roles = new String[]{"Role1", "Role2", "role_Role3"};
        String[] expectedGas = new String[]{"ROLE_Role1", "ROLE_Role2", "ROLE_role_Role3"};
        SimpleAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        mapper.setAddPrefixIfAlreadyExisting(false);
        mapper.setAttributePrefix("ROLE_");
        this.testGetGrantedAuthorities(mapper, roles, expectedGas);
    }

    public final void testGetGrantedAuthoritiesCombination1() {
        String[] roles = new String[]{"Role1", "Role2", "role_Role3"};
        String[] expectedGas = new String[]{"ROLE_ROLE1", "ROLE_ROLE2", "ROLE_ROLE3"};
        SimpleAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        mapper.setAddPrefixIfAlreadyExisting(false);
        mapper.setConvertAttributeToUpperCase(true);
        mapper.setAttributePrefix("ROLE_");
        this.testGetGrantedAuthorities(mapper, roles, expectedGas);
    }

    private void testGetGrantedAuthorities(SimpleAttributes2GrantedAuthoritiesMapper mapper, String[] roles, String[] expectedGas) {
        GrantedAuthority[] result = mapper.getGrantedAuthorities(roles);
        ArrayList<String> resultColl = new ArrayList<String>(result.length);
        for (int i = 0; i < result.length; ++i) {
            resultColl.add(result[i].getAuthority());
        }
        List<String> expectedColl = Arrays.asList(expectedGas);
        SimpleRoles2GrantedAuthoritiesMapperTests.assertTrue((String)("Role collections do not match; result: " + resultColl + ", expected: " + expectedColl), (expectedColl.containsAll(resultColl) && resultColl.containsAll(expectedColl) ? 1 : 0) != 0);
    }

    private SimpleAttributes2GrantedAuthoritiesMapper getDefaultMapper() {
        SimpleAttributes2GrantedAuthoritiesMapper mapper = new SimpleAttributes2GrantedAuthoritiesMapper();
        mapper.setAttributePrefix("");
        mapper.setConvertAttributeToLowerCase(false);
        mapper.setConvertAttributeToUpperCase(false);
        mapper.setAddPrefixIfAlreadyExisting(false);
        return mapper;
    }
}

