/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import nux.xom.pool.FullTextPool;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.memory.AnalyzerUtil;
import org.apache.lucene.index.memory.PatternAnalyzer;
import org.apache.lucene.queryParser.ParseException;

public class FullTextUtil {
    private FullTextUtil() {
    }

    public static float match(String text, String query) throws ParseException {
        return FullTextUtil.match(text, query, null, null);
    }

    public static float match(String text, String query, Analyzer textAnalyzer, Analyzer queryAnalyzer) throws ParseException {
        if (textAnalyzer == null) {
            textAnalyzer = PatternAnalyzer.DEFAULT_ANALYZER;
        }
        if (queryAnalyzer == null) {
            queryAnalyzer = PatternAnalyzer.DEFAULT_ANALYZER;
        }
        return FullTextPool.GLOBAL_POOL.match(text, query, textAnalyzer, queryAnalyzer);
    }

    public static String[] paragraphs(String text, int limit) {
        return AnalyzerUtil.getParagraphs(text, limit);
    }

    public static String[] sentences(String text, int limit) {
        return AnalyzerUtil.getSentences(text, limit);
    }
}

