/*
 * Decompiled with CFR 0.152.
 */
package jmxlogger.tools;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxConfigStore {
    private ConcurrentHashMap<String, Object> config;
    private ArrayList<ConfigEventListener> listeners;
    private ExecutorService publisher;

    public JmxConfigStore() {
        this.config = new ConcurrentHashMap();
        this.listeners = new ArrayList();
        this.setupPublisher();
    }

    public JmxConfigStore(Map<String, Object> values) {
        this.config = new ConcurrentHashMap<String, Object>(values);
        this.listeners = new ArrayList();
        this.setupPublisher();
    }

    public synchronized void addListener(ConfigEventListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(ConfigEventListener l) {
        this.listeners.remove(l);
    }

    public List<ConfigEventListener> getListeners() {
        return this.listeners;
    }

    public synchronized void putValue(String key, Object value) {
        this.config.put(key, value);
    }

    public Object getValue(String key) {
        return this.config.get(key);
    }

    public synchronized Map getValues() {
        return this.config;
    }

    public void clear() {
        this.config.clear();
    }

    private void setupPublisher() {
        this.publisher = Executors.newSingleThreadExecutor();
    }

    public void postEvent(ConfigEvent event) {
        if (event.getSource() == null) {
            throw new IllegalArgumentException("Config Event must have a source.");
        }
        this.publishPutEventToListeners(event, this.listeners);
    }

    private void publishPutEventToListeners(ConfigEvent event, List<ConfigEventListener> listeners) {
        for (ConfigEventListener l : listeners) {
            l.onValueChanged(event);
        }
    }

    public static interface ConfigEventListener
    extends EventListener {
        public void onValueChanged(ConfigEvent var1);
    }

    public static class ConfigEvent
    extends EventObject {
        private String key;
        private Object value;

        public ConfigEvent(Object source, String key, Object value) {
            super(source);
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

