/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.resources;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceListWrapper;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import com.jaspersoft.jasperserver.remote.resources.converters.LookupResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterProvider;
import com.jaspersoft.jasperserver.remote.services.BatchRepositoryService;
import com.jaspersoft.jasperserver.remote.services.SingleRepositoryService;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.service.impl.RepositorySearchCriteriaImpl;
import com.sun.jersey.core.spi.factory.ResponseBuilderImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Service;

@Service
@Path(value="/resources")
public class SearchResourcesJaxrsService {
    public static final String FOLDER_URI = "folderUri";
    @Resource(name="concreteRepository")
    public RepositoryService repositoryService;
    @Resource
    private RepositorySearchService repositorySearchService;
    @Resource
    private BatchRepositoryService batchRepositoryService;
    @Resource
    private SingleRepositoryService singleRepositoryService;
    @Resource
    private LookupResourceConverter lookupResourceConverter;
    @Resource
    private ResourceConverterProvider resourceConverterProvider;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getResources(@QueryParam(value="q") String q, @QueryParam(value="folderUri") String folderUri, @QueryParam(value="type") String type, @QueryParam(value="offset") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="recursive") @DefaultValue(value="true") Boolean recursive, @QueryParam(value="showHiddenItems") @DefaultValue(value="false") Boolean showHiddenItems, @QueryParam(value="forceTotalCount") @DefaultValue(value="false") Boolean forceTotalCount, @QueryParam(value="sortBy") String sortBy) throws IllegalParameterValueException, ResourceNotFoundException {
        if (folderUri != null) {
            this.validateFolderUri(folderUri);
        }
        RepositorySearchCriteriaImpl.Builder builder = new RepositorySearchCriteriaImpl.Builder().setSearchText(q).setFolderUri(folderUri != null ? folderUri : "/").setStartIndex(start != null ? start : 0).setMaxCount(limit != null ? limit : 100).setSearchMode(recursive == null || recursive != false ? SearchMode.SEARCH : SearchMode.BROWSE).setShowHidden(showHiddenItems).setSortBy(sortBy);
        boolean isSearchSuitable = true;
        if (type != null) {
            if (GenericParametersReflectionHelper.extractClientType(ClientResourceLookup.class).equals(type)) {
                isSearchSuitable = false;
            } else if (GenericParametersReflectionHelper.extractClientType(ClientFile.class).equals(type)) {
                builder.setResourceTypes(new String[]{FileResource.class.getName(), ContentResource.class.getName()});
            } else {
                try {
                    builder.setResourceTypes(new String[]{this.resourceConverterProvider.getToServerConverter(type).getServerResourceType()});
                }
                catch (IllegalParameterValueException e) {
                    isSearchSuitable = false;
                }
            }
        }
        RepositorySearchCriteria criteria = builder.getCriteria();
        List results = isSearchSuitable ? this.repositorySearchService.getResults(null, criteria) : null;
        ArrayList<ClientResourceLookup> clientResult = null;
        if (results != null && !results.isEmpty()) {
            clientResult = new ArrayList<ClientResourceLookup>(results.size());
            for (ResourceDetails currentItem : results) {
                ClientResourceLookup clientItem = this.lookupResourceConverter.toClient((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)currentItem);
                clientResult.add(clientItem);
            }
        }
        ResponseBuilderImpl response = new ResponseBuilderImpl();
        if (clientResult != null && clientResult.size() != 0) {
            response.status(Response.Status.OK).entity((Object)new ClientResourceListWrapper(clientResult));
            response.header("Start-Index", (Object)criteria.getStartIndex()).header("Result-Count", (Object)results.size());
            if (criteria.getStartIndex() == 0 && results.size() < criteria.getMaxCount()) {
                response.header("Total-Count", (Object)results.size());
            } else if (criteria.getStartIndex() == 0 && results.size() >= criteria.getMaxCount() || forceTotalCount != null && forceTotalCount.booleanValue()) {
                response.header("Total-Count", (Object)this.repositorySearchService.getResultsCount(null, criteria));
            }
        } else {
            response.status(Response.Status.NO_CONTENT);
        }
        return response.build();
    }

    protected void validateFolderUri(String folderUri) throws IllegalParameterValueException, ResourceNotFoundException {
        if (!folderUri.startsWith("/")) {
            throw new IllegalParameterValueException(FOLDER_URI, folderUri);
        }
        if (this.repositoryService.getFolder(null, folderUri) == null) {
            throw new ResourceNotFoundException(folderUri);
        }
    }

    @DELETE
    public Response deleteResources(@QueryParam(value="resourceUri") List<String> uris) throws RemoteException {
        if (uris == null) {
            throw new IllegalParameterValueException("resourceUri", "null");
        }
        this.batchRepositoryService.deleteResources(uris);
        return Response.noContent().build();
    }

    @POST
    public Response copyResource(@HeaderParam(value="Content-Location") String sourceUri, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders, @QueryParam(value="overwrite") @DefaultValue(value="false") Boolean overwrite) throws RemoteException {
        this.singleRepositoryService.copyResource(sourceUri, "/", createFolders.booleanValue(), overwrite.booleanValue());
        return Response.noContent().build();
    }

    @PUT
    public Response moveResource(@HeaderParam(value="Content-Location") String sourceUri, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders, @QueryParam(value="overwrite") @DefaultValue(value="false") Boolean overwrite) throws RemoteException {
        this.singleRepositoryService.moveResource(sourceUri, "/", createFolders.booleanValue(), overwrite.booleanValue());
        return Response.noContent().build();
    }
}

