/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.resources;

import com.jaspersoft.jasperserver.dto.resources.ClientAwsDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientBeanDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientFolder;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientJndiJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientOlapUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientXmlaConnection;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterProvider;
import com.jaspersoft.jasperserver.remote.resources.converters.ToClientConverter;
import com.jaspersoft.jasperserver.remote.services.SingleRepositoryService;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Service;

@Service
@Path(value="/resources/{uri: .+}")
public class ResourceDetailsJaxrsService {
    @Resource
    private ResourceConverterProvider resourceConverterProvider;
    @Resource(name="singleRepositoryService")
    private SingleRepositoryService singleRepositoryService;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getResourceDetails(@PathParam(value="uri") String uri, @HeaderParam(value="Accept") String accept) throws RemoteException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.singleRepositoryService.getResource("/" + uri);
        ToClientConverter toClientConverter = this.resourceConverterProvider.getToClientConverter(resource);
        ClientResourceLookup clientResourceLookup = (ClientResourceLookup)toClientConverter.toClient((Object)resource);
        String contentTypeTemplate = accept != null && accept.endsWith("json") ? "application/repository.{resourceType}+json" : "application/repository.{resourceType}+xml";
        return Response.ok((Object)clientResourceLookup).header("Content-Type", (Object)contentTypeTemplate.replace("{resourceType}", toClientConverter.getClientResourceType())).build();
    }

    @DELETE
    public Response deleteResource(@PathParam(value="uri") String uri) throws RemoteException {
        this.singleRepositoryService.deleteResource("/" + uri);
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/repository.awsDataSource+xml", "application/repository.awsDataSource+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientAwsDataSource resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.beanDataSource+xml", "application/repository.beanDataSource+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientBeanDataSource resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.customDataSource+xml", "application/repository.customDataSource+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientCustomDataSource resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.dataType+xml", "application/repository.dataType+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientDataType resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.folder+xml", "application/repository.folder+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientFolder resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.jdbcDataSource+xml", "application/repository.jdbcDataSource+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientJdbcDataSource resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.jndiJdbcDataSource+xml", "application/repository.jndiJdbcDataSource+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientJndiJdbcDataSource resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.listOfValues+xml", "application/repository.listOfValues+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientListOfValues resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.olapUnit+xml", "application/repository.olapUnit+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientOlapUnit resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.query+xml", "application/repository.query+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientQuery resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.virtualDataSource+xml", "application/repository.virtualDataSource+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientVirtualDataSource resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.xmlaConnection+xml", "application/repository.xmlaConnection+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientXmlaConnection resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    @Consumes(value={"application/repository.inputControl+xml", "application/repository.inputControl+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createResource(ClientInputControl resourceLookup, @PathParam(value="uri") String parentUri, @HeaderParam(value="Accept") String accept, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders) throws RemoteException {
        return this.createResourceInternal((ClientResourceLookup)resourceLookup, "/" + parentUri, accept, createFolders);
    }

    @POST
    public Response copyResource(@PathParam(value="uri") String uri, @HeaderParam(value="Content-Location") String sourceUri, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders, @QueryParam(value="overwrite") @DefaultValue(value="false") Boolean overwrite) throws RemoteException {
        this.singleRepositoryService.copyResource(sourceUri, "/" + uri, createFolders.booleanValue(), overwrite.booleanValue());
        return Response.noContent().build();
    }

    @PUT
    public Response moveResource(@PathParam(value="uri") String uri, @HeaderParam(value="Content-Location") String sourceUri, @QueryParam(value="createFolders") @DefaultValue(value="true") Boolean createFolders, @QueryParam(value="overwrite") @DefaultValue(value="false") Boolean overwrite) throws RemoteException {
        this.singleRepositoryService.moveResource(sourceUri, "/" + uri, createFolders.booleanValue(), overwrite.booleanValue());
        return Response.noContent().build();
    }

    Response createResourceInternal(ClientResourceLookup resourceLookup, String parentUri, String accept, boolean createFolders) throws RemoteException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource serverResource = (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)this.resourceConverterProvider.getToServerConverter(resourceLookup).toServer((Object)resourceLookup);
        serverResource = this.singleRepositoryService.createResource(serverResource, parentUri, accept, createFolders);
        resourceLookup = (ClientResourceLookup)this.resourceConverterProvider.getToClientConverter(serverResource).toClient((Object)serverResource);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)resourceLookup).build();
    }
}

