/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.report;

import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionHelper;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionStatusEntity;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionsJaxrsService;
import com.jaspersoft.jasperserver.jaxrs.report.ReportsServiceCallTemplate;
import com.jaspersoft.jasperserver.remote.common.AbstractRemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.common.CallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.ExportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportOutputPages;
import com.jaspersoft.jasperserver.remote.services.ReportOutputResource;
import com.jaspersoft.jasperserver.remote.services.RunReportService;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Service;

@Service
@Path(value="/reports")
@CallTemplate(value=ReportsServiceCallTemplate.class)
public class RunReportsJaxrsService
extends RemoteServiceWrapper<RunReportService> {
    @Resource
    private ReportExecutionsJaxrsService reportExecutionsJaxrsService;

    @Resource(name="runReportService")
    public void setRemoteService(RunReportService remoteService) {
        this.remoteService = remoteService;
    }

    @GET
    @Path(value="/{reportUnitURI: .+}.{outputFormat}")
    public Response getReportOutputResource(final @PathParam(value="reportUnitURI") String reportUnitURI, final @PathParam(value="outputFormat") String outputFormat, final @QueryParam(value="page") Integer page, final @QueryParam(value="pages") String pages, final @QueryParam(value="transformerKey") String transformerKey, final @QueryParam(value="ignorePagination") @DefaultValue(value="false") Boolean ignorePagination, final @QueryParam(value="attachmentsPrefix") String attachmentsPrefix, final @Context HttpServletRequest request, final @QueryParam(value="freshData") @DefaultValue(value="false") Boolean freshData, final @QueryParam(value="interactive") @DefaultValue(value="true") Boolean interactive, final @QueryParam(value="saveDataSnapshot") @DefaultValue(value="false") Boolean saveDataSnapshot) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                String requestURI = request.getRequestURI();
                Map parameterMap = request.getParameterMap();
                ReportExecutionOptions reportExecutionOptions = new ReportExecutionOptions().setIgnorePagination(ignorePagination).setTransformerKey(transformerKey).setDefaultAttachmentsPrefixTemplate(ReportExecutionHelper.getDefaultAttachmentsPrefixTemplateFromRequest(requestURI.substring(request.getContextPath().length(), requestURI.indexOf(reportUnitURI)).replace("/reports/", "/reportExecutions/"))).setFreshData(freshData).setSaveDataSnapshot(saveDataSnapshot).setInteractive(interactive).setContextPath(request.getContextPath());
                ExportExecutionOptions exportOptions = new ExportExecutionOptions().setOutputFormat(outputFormat).setPages(ReportOutputPages.valueOf((String)(page != null ? page.toString() : pages))).setAttachmentsPrefix(attachmentsPrefix);
                ReportOutputResource reportOutputResource = remoteService.getReportOutputFromRawParameters("/" + reportUnitURI, parameterMap, reportExecutionOptions, exportOptions);
                return ReportExecutionHelper.buildResponseFromOutputResource(reportOutputResource);
            }
        });
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getReportsRuntimeInformation(@QueryParam(value="reportURI") String reportURI, @QueryParam(value="jobID") String jobID, @QueryParam(value="jobLabel") String jobLabel, @QueryParam(value="userName") String userName, @QueryParam(value="fireTimeFrom") String fireTimeFrom, @QueryParam(value="fireTimeTo") String fireTimeTo) {
        return this.reportExecutionsJaxrsService.getReportsRuntimeInformation(reportURI, jobID, jobLabel, userName, fireTimeFrom, fireTimeTo);
    }

    @PUT
    @Path(value="/{executionId}/status")
    @Consumes(value={"application/xml", "application/json"})
    public Response cancelReportExecution(@PathParam(value="executionId") String executionId, ReportExecutionStatusEntity statusEntity) {
        return this.reportExecutionsJaxrsService.cancelReportExecution(executionId, statusEntity);
    }
}

