/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.permission;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.dto.permissions.RepositoryPermission;
import com.jaspersoft.jasperserver.dto.permissions.RepositoryPermissionListWrapper;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.helpers.PermissionsRecipientIdentity;
import com.jaspersoft.jasperserver.remote.helpers.PermissionsRecipientIdentityResolver;
import com.jaspersoft.jasperserver.remote.resources.converters.PermissionConverter;
import com.jaspersoft.jasperserver.remote.services.PermissionsService;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.stereotype.Component;

@Component
@Path(value="/permissions")
public class RepositoryPermissionsJaxrsService {
    @Resource(name="concretePermissionsService")
    private PermissionsService service;
    @Resource(name="concretePermissionsRecipientIdentityResolver")
    private PermissionsRecipientIdentityResolver permissionRecipientIdentityResolver;
    @Resource(name="permissionConverter")
    private PermissionConverter converter;

    @GET
    @Path(value="/{uri:.+}")
    @Produces(value={"application/xml", "application/json"})
    public Response getPermissionsEntryPoint(@Context UriInfo uriInfo) throws RemoteException {
        PermissionComplexKey permissionComplexKey = new PermissionComplexKey(uriInfo).invoke();
        MultivaluedMap<String, String> queryParams = permissionComplexKey.getQueryParams();
        Response response = permissionComplexKey.getRecipientUri() == null ? this.getPermissions(permissionComplexKey.getResourceUri(), "true".equalsIgnoreCase((String)queryParams.getFirst((Object)"effectivePermissions")), (String)queryParams.getFirst((Object)"recipientType"), (String)queryParams.getFirst((Object)"recipientId"), "true".equalsIgnoreCase((String)queryParams.getFirst((Object)"resolveAll")), this.parseIntParam("offset", (String)queryParams.getFirst((Object)"offset")), this.parseIntParam("limit", (String)queryParams.getFirst((Object)"limit"))) : this.getPermission(permissionComplexKey.getResourceUri(), permissionComplexKey.getRecipientUri());
        return response;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getPermissionsEntryPointRoot(@Context UriInfo uriInfo) throws RemoteException {
        return this.getPermissionsEntryPoint(uriInfo);
    }

    @POST
    @Consumes(value={"application/collection+xml", "application/collection+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createPermissions(RepositoryPermissionListWrapper data) throws RemoteException {
        List permissions = data.getPermissions();
        ArrayList<ObjectPermission> server = new ArrayList<ObjectPermission>(permissions.size());
        for (RepositoryPermission repositoryPermission : permissions) {
            server.add(this.converter.toServer(repositoryPermission));
        }
        this.service.createPermissions(server);
        permissions.clear();
        for (ObjectPermission objectPermission : server) {
            permissions.add(this.converter.toClient(objectPermission));
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new RepositoryPermissionListWrapper(permissions)).build();
    }

    @DELETE
    @Path(value="/{uri:.+}")
    public Response deletePermissionsEntryPoint(@Context UriInfo uriInfo) throws RemoteException {
        PermissionComplexKey permissionComplexKey = new PermissionComplexKey(uriInfo).invoke();
        if (permissionComplexKey.getRecipientUri() == null) {
            this.deletePermissions(permissionComplexKey.getResourceUri());
        } else {
            this.deletePermission(permissionComplexKey.getResourceUri(), permissionComplexKey.getRecipientUri());
        }
        return Response.noContent().build();
    }

    @DELETE
    public Response deletePermissionsEntryPointRoot(@Context UriInfo uriInfo) throws RemoteException {
        return this.deletePermissionsEntryPoint(uriInfo);
    }

    @PUT
    @Path(value="/{uri:.+}")
    @Consumes(value={"application/collection+xml", "application/collection+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updatePermissions(RepositoryPermissionListWrapper data, @PathParam(value="uri") String resourceUri) throws RemoteException {
        List permissions = data.getPermissions();
        ArrayList<ObjectPermission> server = new ArrayList<ObjectPermission>(permissions.size());
        for (RepositoryPermission repositoryPermission : permissions) {
            server.add(this.converter.toServer(repositoryPermission));
        }
        this.service.putPermissions("/" + resourceUri, server);
        permissions.clear();
        for (ObjectPermission objectPermission : server) {
            permissions.add(this.converter.toClient(objectPermission));
        }
        return Response.ok().entity((Object)new RepositoryPermissionListWrapper(permissions)).build();
    }

    @PUT
    @Consumes(value={"application/collection+xml", "application/collection+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updatePermissionsRoot(RepositoryPermissionListWrapper data) throws RemoteException {
        return this.updatePermissions(data, "");
    }

    @PUT
    @Path(value="/{uri:.+}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updatePermission(RepositoryPermission permission, @Context UriInfo uriInfo) throws RemoteException {
        PermissionComplexKey permissionComplexKey = new PermissionComplexKey(uriInfo).invoke();
        permission.setUri(permissionComplexKey.getResourceUri());
        permission.setRecipient(permissionComplexKey.getRecipientUri());
        this.service.putPermission(this.converter.toServer(permission));
        return Response.ok().entity((Object)permission).build();
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updatePermissionRoot(RepositoryPermission permission, @Context UriInfo uriInfo) throws RemoteException {
        return this.updatePermission(permission, uriInfo);
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createPermission(RepositoryPermission permission) throws RemoteException {
        this.service.createPermission(this.converter.toServer(permission));
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)permission).build();
    }

    private Response getPermission(String resourceUri, String recipientUri) throws RemoteException {
        PermissionsRecipientIdentity identity = this.permissionRecipientIdentityResolver.toIdentity(recipientUri);
        ObjectPermission permission = this.service.getPermission(resourceUri, identity.getRecipientClass(), identity.getId());
        if (permission == null) {
            throw new ResourceNotFoundException(resourceUri + ";" + recipientUri);
        }
        return Response.ok((Object)this.converter.toClient(permission)).build();
    }

    private Response getPermissions(String resourceUri, boolean effectivePermissions, String recipientType, String recipientId, boolean resolveAll, int startIndex, int limit) throws RemoteException {
        Class recipientClass = this.permissionRecipientIdentityResolver.getClassForProtocol(recipientType);
        List permissions = this.service.getPermissions(resourceUri, recipientClass, recipientId, effectivePermissions, resolveAll);
        int totalCount = permissions.size();
        if (totalCount < startIndex) {
            permissions.clear();
        } else if (limit > 0) {
            permissions = startIndex + limit > totalCount ? permissions.subList(startIndex, totalCount) : permissions.subList(startIndex, startIndex + limit);
        } else if (startIndex > 0) {
            permissions = permissions.subList(startIndex, totalCount);
        }
        ArrayList<RepositoryPermission> client = new ArrayList<RepositoryPermission>(permissions.size());
        for (ObjectPermission permission : permissions) {
            client.add(this.converter.toClient(permission));
        }
        Response response = permissions.size() == 0 ? Response.status((Response.Status)Response.Status.NO_CONTENT).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)permissions.size()).header("Total-Count", (Object)totalCount).build() : Response.ok().entity((Object)new RepositoryPermissionListWrapper(client)).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)permissions.size()).header("Total-Count", (Object)totalCount).build();
        return response;
    }

    private void deletePermissions(String resourceUri) throws RemoteException {
        List permissions = this.service.getPermissions(resourceUri, null, null, false, false);
        for (ObjectPermission permission : permissions) {
            this.service.deletePermission(permission);
        }
    }

    private void deletePermission(String resourceUri, String recipientUri) throws RemoteException {
        PermissionsRecipientIdentity identity = this.permissionRecipientIdentityResolver.toIdentity(recipientUri);
        ObjectPermission permission = this.service.getPermission(resourceUri, identity.getRecipientClass(), identity.getId());
        if (permission == null) {
            throw new ResourceNotFoundException(resourceUri + ";" + recipientUri);
        }
        this.service.deletePermission(permission);
    }

    private int parseIntParam(String name, String value) throws IllegalParameterValueException {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new IllegalParameterValueException(name, value);
            }
        }
        return 0;
    }

    protected class PermissionComplexKey {
        private UriInfo uriInfo;
        private MultivaluedMap<String, String> queryParams;
        private String resourceUri;
        private String recipientUri;

        public PermissionComplexKey(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }

        public MultivaluedMap<String, String> getQueryParams() {
            return this.queryParams;
        }

        public String getResourceUri() {
            return this.resourceUri;
        }

        public String getRecipientUri() {
            return this.recipientUri;
        }

        public PermissionComplexKey invoke() {
            List segments = this.uriInfo.getPathSegments();
            this.queryParams = this.uriInfo.getQueryParameters(true);
            if (this.queryParams == null) {
                this.queryParams = new MultivaluedMapImpl();
            }
            StringBuilder resourceUri = new StringBuilder();
            this.recipientUri = null;
            if (segments.size() > 1) {
                for (int i = 1; i < segments.size() && this.recipientUri == null; ++i) {
                    resourceUri.append("/").append(((PathSegment)segments.get(i)).getPath());
                    this.recipientUri = (String)((PathSegment)segments.get(i)).getMatrixParameters().getFirst((Object)"recipient");
                }
                this.resourceUri = resourceUri.toString();
            } else {
                this.resourceUri = "/";
                this.recipientUri = (String)((PathSegment)segments.get(0)).getMatrixParameters().getFirst((Object)"recipient");
            }
            return this;
        }
    }
}

