/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.authority;

import com.jaspersoft.jasperserver.dto.authority.ClientRole;
import com.jaspersoft.jasperserver.jaxrs.authority.RolesJaxrsService;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/roles")
public class RolesJaxrsServiceWrapper {
    @Resource(name="rolesJaxrsService")
    private RolesJaxrsService service;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getRoles(@QueryParam(value="maxRecords") int maxRecords, @QueryParam(value="offset") Integer startIndex, @QueryParam(value="limit") Integer limit, @QueryParam(value="subOrgId") String tenantId, @QueryParam(value="includeSubOrgs") Boolean includeSubOrgs, @QueryParam(value="search") String search, @QueryParam(value="q") String q, @QueryParam(value="hasAllUsers") Boolean hasAllUsers, @QueryParam(value="user") List<String> userNames) throws RemoteException {
        if (limit != null) {
            maxRecords = limit;
        }
        if (q != null) {
            search = q;
        }
        return this.service.getRoles(startIndex == null ? 0 : startIndex, maxRecords, tenantId, includeSubOrgs, search, hasAllUsers, userNames);
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response getRoles(@PathParam(value="name") String name) throws RemoteException {
        return this.service.getRoles(name, null);
    }

    @DELETE
    @Path(value="/{name}")
    public Response deleteRole(@PathParam(value="name") String name) throws RemoteException {
        return this.service.deleteRole(name, null);
    }

    @PUT
    @Path(value="/{name}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateRole(ClientRole newRole, @PathParam(value="name") String name) throws RemoteException {
        if (newRole.getTenantId() != null) {
            throw new IllegalParameterValueException("tenantId", newRole.getTenantId());
        }
        return this.service.updateRole(newRole, name, null);
    }
}

