/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.authority;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.dto.authority.ClientRole;
import com.jaspersoft.jasperserver.dto.authority.RolesListWrapper;
import com.jaspersoft.jasperserver.remote.common.RoleSearchCriteria;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceAlreadyExistsException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.converters.RoleConverter;
import com.jaspersoft.jasperserver.remote.services.UserAndRoleService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.core.Response;
import org.springframework.security.AccessDeniedException;

public class RolesJaxrsService {
    private UserAndRoleService service;
    @Resource(name="roleConverter")
    private RoleConverter converter;

    public Response getRoles(int startIndex, int maxRecords, String tenantId, Boolean includeSubOrgs, String search, Boolean hasAllUsers, List<String> userNames) throws RemoteException {
        RoleSearchCriteria criteria = new RoleSearchCriteria();
        criteria.setRoleName("".equals(search) ? null : search);
        criteria.setTenantId("".equals(tenantId) ? null : tenantId);
        criteria.setIncludeSubOrgs(includeSubOrgs);
        criteria.setHasAllUsers(hasAllUsers);
        criteria.setUsersNames(userNames);
        List roles = this.service.findRoles(criteria);
        int totalCount = roles.size();
        if (totalCount < startIndex) {
            roles.clear();
        } else if (maxRecords != 0) {
            roles = startIndex + maxRecords > totalCount ? roles.subList(startIndex, totalCount) : roles.subList(startIndex, startIndex + maxRecords);
        } else if (startIndex > 0) {
            roles = roles.subList(startIndex, totalCount);
        }
        ArrayList<ClientRole> clientRoles = new ArrayList<ClientRole>(roles.size());
        for (Role role : roles) {
            clientRoles.add(this.converter.toClient(role));
        }
        Response response = roles.size() == 0 ? Response.status((Response.Status)Response.Status.NO_CONTENT).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)roles.size()).header("Total-Count", (Object)totalCount).build() : Response.ok().entity((Object)new RolesListWrapper(clientRoles)).header("Start-Index", (Object)startIndex).header("Result-Count", (Object)roles.size()).header("Total-Count", (Object)totalCount).build();
        return response;
    }

    public Response getRoles(String name, String tenantId) throws RemoteException {
        Role role = this.findRole(name, tenantId);
        if (role == null) {
            throw new ResourceNotFoundException(name);
        }
        return Response.ok((Object)this.converter.toClient(role)).build();
    }

    public Response deleteRole(String name, String tenantId) throws RemoteException {
        Role role = this.findRole(name, tenantId);
        if (role == null) {
            throw new ResourceNotFoundException(name);
        }
        try {
            this.service.deleteRole(role);
        }
        catch (AccessDeniedException ade) {
            throw new com.jaspersoft.jasperserver.remote.exception.AccessDeniedException(ade.getMessage());
        }
        return Response.noContent().build();
    }

    public Response createRole(ClientRole clientRole) throws RemoteException {
        Role role = this.converter.toServer(clientRole);
        ArrayList<ClientRole> res = new ArrayList<ClientRole>(1);
        if (this.findRole(role.getRoleName(), role.getTenantId()) != null) {
            throw new ResourceAlreadyExistsException(role.getRoleName());
        }
        res.add(this.converter.toClient(this.service.putRole(role)));
        RolesListWrapper wrapper = new RolesListWrapper(res);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)wrapper).build();
    }

    public Response updateRole(ClientRole newRole, String name, String tenantId) throws RemoteException {
        ArrayList<ClientRole> res = new ArrayList<ClientRole>(1);
        Role oldRole = this.findRole(name, tenantId);
        if (oldRole != null) {
            if (this.findRole(newRole.getName(), tenantId) != null) {
                throw new ResourceAlreadyExistsException(newRole.getName());
            }
        } else {
            newRole.setName(name);
            newRole.setTenantId(tenantId);
            return this.createRole(newRole);
        }
        res.add(this.converter.toClient(this.service.updateRoleName(oldRole, newRole.getName())));
        RolesListWrapper wrapper = new RolesListWrapper(res);
        return Response.ok((Object)wrapper).build();
    }

    private boolean requestedRole(Role role, String name, String tenantId) {
        return role.getRoleName().equals(name) && (role.getTenantId() == null && tenantId == null || role.getTenantId() != null && role.getTenantId().equals(tenantId));
    }

    private Role findRole(String name, String tenantId) throws RemoteException {
        RoleSearchCriteria crit = new RoleSearchCriteria();
        crit.setRoleName(name);
        crit.setTenantId(tenantId);
        List found = this.service.findRoles(crit);
        for (Role role : found) {
            if (!this.requestedRole(role, name, tenantId)) continue;
            return role;
        }
        return null;
    }

    public UserAndRoleService getService() {
        return this.service;
    }

    public void setService(UserAndRoleService service) {
        this.service = service;
    }
}

