/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.TenantAwareGrantedAuthority;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class UserDetailsServiceImpl
implements UserDetailsService {
    protected static final Log log = LogFactory.getLog(UserDetailsServiceImpl.class);
    private List defaultInternalRoles;
    private List defaultAdminRoles;
    private List adminUsers;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (this.adminUsers.contains(username)) {
            log.debug((Object)("User " + username + " is an admin"));
            return this.detailsFromList(this.defaultAdminRoles, username);
        }
        log.debug((Object)("User " + username + " is not an admin, getting default authorities"));
        return this.detailsFromList(this.defaultInternalRoles, username);
    }

    public void setDefaultInternalRoles(List defaultInternalRoles) {
        this.defaultInternalRoles = defaultInternalRoles;
    }

    public void setDefaultAdminRoles(List defaultAdminRoles) {
        this.defaultAdminRoles = defaultAdminRoles;
    }

    public void setAdminUsers(List adminUsers) {
        this.adminUsers = adminUsers;
    }

    public List getDefaultInternalRoles() {
        return this.defaultInternalRoles;
    }

    public List getDefaultAdminRoles() {
        return this.defaultAdminRoles;
    }

    public List getAdminUsers() {
        return this.adminUsers;
    }

    private UserDetails detailsFromList(List roles, String username) {
        GrantedAuthority[] authorities;
        GrantedAuthority[] grantedAuthorityArray = authorities = roles == null ? new GrantedAuthority[]{} : new GrantedAuthority[roles.size()];
        if (roles == null) {
            return new UserDetailsImpl(authorities, username);
        }
        Iterator it = roles.iterator();
        int i = 0;
        while (it.hasNext()) {
            authorities[i++] = new TenantAwareGrantedAuthority((String)it.next());
        }
        return new UserDetailsImpl(authorities, username);
    }

    public static class UserDetailsImpl
    implements UserDetails {
        private GrantedAuthority[] authorities;
        private String username;

        public UserDetailsImpl(GrantedAuthority[] authorities, String username) {
            this.authorities = authorities;
            this.username = username;
        }

        public GrantedAuthority[] getAuthorities() {
            return this.authorities;
        }

        public String getPassword() {
            return null;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isAccountNonExpired() {
            return true;
        }

        public boolean isAccountNonLocked() {
            return true;
        }

        public boolean isCredentialsNonExpired() {
            return true;
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

