/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.util.ImportRunMonitor;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.impl.IdedObject;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ObjectPermissionImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.ObjectPermissionRecipientIdentity;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.AclService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.InternalURIDefinition;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ObjectPermissionServiceInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.AclProvider;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.BasicAclDao;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.acl.basic.BasicAclEntryCache;
import org.springframework.security.acl.basic.EffectiveAclsResolver;
import org.springframework.security.acl.basic.GrantedAuthorityEffectiveAclsResolver;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.acl.basic.cache.NullAclEntryCache;
import org.springframework.security.context.SecurityContextHolder;

public class ObjectPermissionServiceImpl
extends HibernateDaoImpl
implements BasicAclDao,
AclProvider,
AclService,
ObjectPermissionService,
ObjectPermissionServiceInternal,
ApplicationContextAware,
PersistentObjectResolver,
InitializingBean {
    protected static final Log log = LogFactory.getLog(ObjectPermissionServiceImpl.class);
    public static final String RECIPIENT_USED_FOR_INHERITANCE_MARKER = "___INHERITANCE_MARKER_ONLY___";
    protected static final String RESOURCE_URI_PREFIX = "repo:";
    protected static final int RESOURCE_URI_PREFIX_LENGTH = "repo:".length();
    static String RECIPIENT_FOR_CACHE_EMPTY = "RESERVED_RECIPIENT_NOBODY";
    private HibernateRepositoryService repoService;
    private UserAuthorityService userService;
    private ResourceFactory objectFactory;
    private ResourceFactory persistentClassFactory;
    private BasicAclEntryCache basicAclEntryCache = new NullAclEntryCache();
    private EffectiveAclsResolver effectiveAclsResolver = new GrantedAuthorityEffectiveAclsResolver();
    private ApplicationContext appContext;
    private AuditContext auditContext;

    public HibernateRepositoryService getRepositoryService() {
        return this.repoService;
    }

    public void setRepositoryService(HibernateRepositoryService repoService) {
        this.repoService = repoService;
    }

    public UserAuthorityService getUserAuthorityService() {
        return this.userService;
    }

    public void setUserAuthorityService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public ResourceFactory getObjectMappingFactory() {
        return this.objectFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ResourceFactory getPersistentClassFactory() {
        return this.persistentClassFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    public void setBasicAclEntryCache(BasicAclEntryCache basicAclEntryCache) {
        this.basicAclEntryCache = basicAclEntryCache;
    }

    public BasicAclEntryCache getBasicAclEntryCache() {
        return this.basicAclEntryCache;
    }

    public EffectiveAclsResolver getEffectiveAclsResolver() {
        return this.effectiveAclsResolver;
    }

    public void setEffectiveAclsResolver(EffectiveAclsResolver effectiveAclsResolver) {
        this.effectiveAclsResolver = effectiveAclsResolver;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.appContext = arg0;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    @Override
    public BasicAclEntry[] getAcls(String uri) {
        BasicAclEntry[] entries = this.checkImport(uri);
        if (entries != null) {
            return entries;
        }
        ResourceLookup res = this.getRepositoryService().getResourceLookupUnsecure(null, uri);
        if (res == null) {
            res = this.getRepositoryService().getFolderUnsecure(null, uri);
        }
        if (res != null) {
            return this.getAcls((InternalURI)res);
        }
        return null;
    }

    @Override
    public BasicAclEntry[] getAcls(InternalURI targetURI) {
        if (targetURI == null) {
            this.logger.error((Object)"getAcls(InternalURI targetURI): returning. null targetURI");
            return null;
        }
        BasicAclEntry[] entries = this.checkImport(targetURI.getURI());
        if (entries != null) {
            return entries;
        }
        HashMap<Object, BasicAclEntry> map = new HashMap<Object, BasicAclEntry>();
        BasicAclEntry[] instanceAclEntries = null;
        if (targetURI instanceof Resource && ((Resource)targetURI).isNew()) {
            ResourceLookup res = this.getRepositoryService().getResourceLookupUnsecure(null, RESOURCE_URI_PREFIX + targetURI.getPath());
            if (res == null) {
                res = this.getRepositoryService().getFolderUnsecure(null, RESOURCE_URI_PREFIX + targetURI.getPath());
            }
            if (res == null) {
                instanceAclEntries = this.lookup(this.getParentURI(RESOURCE_URI_PREFIX + targetURI.getPath()), null);
            }
        } else {
            instanceAclEntries = this.lookup(RESOURCE_URI_PREFIX + targetURI.getPath(), targetURI);
        }
        if (instanceAclEntries == null) {
            return null;
        }
        for (int i = 0; i < instanceAclEntries.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Explicit add: " + instanceAclEntries[i].toString()));
            }
            map.put(instanceAclEntries[i].getRecipient(), instanceAclEntries[i]);
        }
        String parent = this.getParentURI(RESOURCE_URI_PREFIX + targetURI.getPath());
        while (parent != null) {
            BasicAclEntry[] parentAclEntries = this.lookup(parent, null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parent lookup: " + parent));
            }
            if (parentAclEntries == null) {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)"Parent could not be found in ACL repository");
                break;
            }
            for (int i = 0; i < parentAclEntries.length; ++i) {
                if (!map.containsKey(parentAclEntries[i].getRecipient())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Added parent to map: " + parentAclEntries[i].toString() + " for recipient: " + parentAclEntries[i].getRecipient()));
                    }
                    map.put(parentAclEntries[i].getRecipient(), parentAclEntries[i]);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Did NOT add parent to map: " + parentAclEntries[i].toString() + " for recipient: " + parentAclEntries[i].getRecipient()));
            }
            parent = this.getParentURI(parent);
        }
        Collection collection = map.values();
        return collection.toArray(new BasicAclEntry[0]);
    }

    public BasicAclEntry[] getAcls(AclObjectIdentity aclObjectIdentity) {
        if (aclObjectIdentity == null || !(aclObjectIdentity instanceof InternalURI)) {
            this.logger.debug((Object)("getAcls(AclObjectIdentity aclObjectIdentity): returning. invalid object for getAcls: " + aclObjectIdentity));
            return null;
        }
        InternalURI targetURI = (InternalURI)aclObjectIdentity;
        return this.getAcls(targetURI);
    }

    public BasicAclEntry[] getAcls(AclObjectIdentity aclObjectIdentity, Object recipient) {
        if (aclObjectIdentity == null || !(aclObjectIdentity instanceof InternalURI)) {
            this.logger.debug((Object)("getAcls(AclObjectIdentity aclObjectIdentity, Object recipient): returning. invalid object for getAcls: " + aclObjectIdentity));
            return null;
        }
        InternalURI targetURI = (InternalURI)aclObjectIdentity;
        return this.getAclsForRecipient(RESOURCE_URI_PREFIX + targetURI.getPath(), recipient);
    }

    private BasicAclEntry[] checkImport(String uri) {
        BasicAclEntry[] res = null;
        if (ImportRunMonitor.isImportRun()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                if (!authority.getAuthority().equals("PRIVILEGED_OPERATION")) continue;
                ObjectPermissionImpl permission = new ObjectPermissionImpl();
                permission.setPermissionMask(SimpleAclEntry.ADMINISTRATION);
                permission.setPermissionRecipient(SecurityContextHolder.getContext().getAuthentication().getPrincipal());
                res = new BasicAclEntry[]{this.createBasicAclEntry(uri, (ObjectPermission)permission)};
            }
        }
        return res;
    }

    private BasicAclEntry[] getAclsForRecipient(String targetURI, Object recipient) {
        HashMap<Object, BasicAclEntry> map = new HashMap<Object, BasicAclEntry>();
        while (targetURI != null) {
            BasicAclEntry[] entries = this.lookup(targetURI, null);
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    if (!(recipient != null && recipient == entries[i].getRecipient() || map.containsKey(entries[i].getRecipient()))) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Added: " + entries[i].toString()));
                        }
                        map.put(entries[i].getRecipient(), entries[i]);
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Did NOT add: " + entries[i].toString()));
                }
            }
            targetURI = this.getParentURI(targetURI);
        }
        Collection collection = map.values();
        return collection.toArray(new BasicAclEntry[0]);
    }

    private BasicAclEntry[] getAclsFromObjectPermissions(String targetURI, List permissions) {
        if (permissions == null || permissions.size() == 0) {
            log.debug((Object)"No explicit permissions found");
            return new BasicAclEntry[]{this.createBasicAclEntry(targetURI, null)};
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + permissions.size() + " explicit permissions"));
        }
        ObjectPermission[] aclHolders = permissions.toArray(new ObjectPermission[0]);
        ArrayList<BasicAclEntry> toReturnAcls = new ArrayList<BasicAclEntry>(aclHolders.length);
        for (int i = 0; i < aclHolders.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)aclHolders[i]);
            }
            toReturnAcls.add(this.createBasicAclEntry(targetURI, aclHolders[i]));
        }
        return toReturnAcls.toArray(new BasicAclEntry[0]);
    }

    BasicAclEntry createBasicAclEntry(String targetURI, ObjectPermission aclInformation) {
        BasicAclEntry entry;
        try {
            entry = (BasicAclEntry)SimpleAclEntry.class.newInstance();
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        entry.setAclObjectIdentity((AclObjectIdentity)new URIObjectIdentity(targetURI));
        entry.setAclObjectParentIdentity((AclObjectIdentity)new URIObjectIdentity(this.getParentURI(targetURI)));
        if (aclInformation == null) {
            entry.setMask(0);
            entry.setRecipient((Object)RECIPIENT_USED_FOR_INHERITANCE_MARKER);
        } else {
            entry.setMask(aclInformation.getPermissionMask());
            entry.setRecipient(aclInformation.getPermissionRecipient());
        }
        return entry;
    }

    private String getParentURI(String currentURI) {
        if (currentURI == null || currentURI.trim().length() == 0) {
            return null;
        }
        String workUri = currentURI.startsWith(RESOURCE_URI_PREFIX) ? currentURI.substring(RESOURCE_URI_PREFIX_LENGTH).trim() : currentURI.trim();
        int lastSeparator = workUri.lastIndexOf("/");
        if (lastSeparator < 0) {
            return null;
        }
        if (lastSeparator == 0) {
            if (workUri.length() == 1) {
                return null;
            }
            return "repo:/";
        }
        return RESOURCE_URI_PREFIX + workUri.substring(0, lastSeparator);
    }

    public AclEntry[] getAcls(Object obj) {
        ArrayList resultList = new ArrayList();
        if (obj instanceof InternalURI) {
            return this.getAcls((InternalURI)obj);
        }
        if (obj instanceof String) {
            String path = (String)obj;
            if (path.startsWith(RESOURCE_URI_PREFIX)) {
                path = path.substring(RESOURCE_URI_PREFIX_LENGTH);
            }
            return this.getAcls(new InternalURIDefinition(path));
        }
        return resultList.toArray(new BasicAclEntry[0]);
    }

    public AclEntry[] getAcls(Object obj, Authentication auth) {
        if (auth == null || auth.getPrincipal() == null || !(obj instanceof InternalURI) && !(obj instanceof String)) {
            return new BasicAclEntry[0];
        }
        AclEntry[] allAcls = this.getAcls(obj);
        return this.effectiveAclsResolver.resolveEffectiveAcls(allAcls, auth);
    }

    private BasicAclEntry[] lookup(String targetURI, InternalURI targetObject) {
        URIObjectIdentity objIdent = new URIObjectIdentity(targetURI);
        BasicAclEntry[] result = this.basicAclEntryCache.getEntriesFromCache((AclObjectIdentity)objIdent);
        if (result != null && result.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + targetURI + " in cache"));
            }
            if (result[0].getRecipient() == null || result[0].getRecipient().equals(RECIPIENT_FOR_CACHE_EMPTY)) {
                return null;
            }
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Did not find " + targetURI + " in cache"));
        }
        Resource res = null;
        if (targetObject instanceof Resource) {
            res = (Resource)targetObject;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking up permissions for resource object " + res.getURIString()));
            }
        } else {
            res = this.getRepositoryService().getResourceLookupUnsecure(null, targetURI);
            if (res == null) {
                res = this.getRepositoryService().getFolderUnsecure(null, targetURI);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Did not find " + targetURI + " as resource"));
                    log.debug((Object)("Did " + (res == null ? "not" : "") + " find " + targetURI + " as folder"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + targetURI + " as resource"));
            }
        }
        if (res == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource not found for permissions lookup: " + targetURI + ". Using parent permissions"));
            }
            return this.lookup(this.getParentURI(targetURI), null);
        }
        List permissions = this.getObjectPermissionsForObject(null, res);
        result = this.getAclsFromObjectPermissions(targetURI, permissions);
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Default entries for " + targetURI + " cached"));
            }
            SimpleAclEntry[] emptyAclEntries = new SimpleAclEntry[]{new SimpleAclEntry((Object)RECIPIENT_FOR_CACHE_EMPTY, (AclObjectIdentity)new URIObjectIdentity(targetURI), null, 0)};
            this.basicAclEntryCache.putEntriesInCache((BasicAclEntry[])emptyAclEntries);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(result.length + " entries for " + targetURI + " cached"));
        }
        this.basicAclEntryCache.putEntriesInCache(result);
        return result;
    }

    public void deleteObjectPermissionForObject(ExecutionContext context, Object targetObject) {
        if (targetObject == null || !(targetObject instanceof InternalURI)) {
            return;
        }
        InternalURI res = (InternalURI)targetObject;
        this.deleteObjectPermissionForRepositoryPath(context, res.getPath());
    }

    @Override
    public void deleteObjectPermissionForRepositoryPath(ExecutionContext context, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting object permissions for repository path " + path));
        }
        List permissions = this.getRepoObjectPermissions(context, this.repositoryURI(path), null);
        this.deleteObjectPermissions(permissions, false);
    }

    public void deleteObjectPermissionsForRecipient(ExecutionContext context, Object recipient) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting object permissions for recipient " + recipient));
        }
        List permissions = this.getRepoObjectPermissions(context, null, recipient);
        this.deleteObjectPermissions(permissions);
    }

    @Override
    public void deleteObjectPermissionsForRecipient(ExecutionContext context, ObjectPermissionRecipientIdentity recipientIdentity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting object permissions for recipient " + recipientIdentity));
        }
        List permissions = this.getRepoObjectPermissions(recipientIdentity);
        this.deleteObjectPermissions(permissions);
    }

    protected void deleteObjectPermissions(List permissions) {
        this.deleteObjectPermissions(permissions, true);
    }

    protected void deleteObjectPermissions(List permissions, boolean checkAdministerAccess) {
        if (permissions != null && !permissions.isEmpty()) {
            for (RepoObjectPermission permission : permissions) {
                this.deleteObjectPermission(permission, checkAdministerAccess);
            }
        }
    }

    public boolean supports(Object obj) {
        return obj instanceof InternalURI || obj instanceof String;
    }

    public ObjectPermission newObjectPermission(ExecutionContext context) {
        return (ObjectPermission)this.getObjectMappingFactory().newObject(ObjectPermission.class);
    }

    private void addParamsToSetPermissionAuditEvent(final ExecutionContext context, final ObjectPermission objPermission, final int previousPermissionValue) {
        String[] eventNames = new String[]{"createPermission", "updatePermission", "deletePermission"};
        this.auditContext.doInAuditContext(eventNames, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                Resource resource = ObjectPermissionServiceImpl.this.repoService.getResource(context, objPermission.getURI());
                if (resource != null) {
                    ObjectPermissionServiceImpl.this.auditContext.setResourceTypeToAuditEvent(resource.getResourceType(), auditEvent);
                } else {
                    ObjectPermissionServiceImpl.this.auditContext.setResourceTypeToAuditEvent(Folder.class.getName(), auditEvent);
                }
                auditEvent.setResourceUri(objPermission.getURI());
                String recipientType = "UNKNOWN";
                String recipientName = null;
                String recipientTenantId = null;
                if (objPermission.getPermissionRecipient() instanceof User) {
                    recipientType = "USER";
                    recipientName = ((User)objPermission.getPermissionRecipient()).getUsername();
                    recipientTenantId = ((User)objPermission.getPermissionRecipient()).getTenantId();
                } else if (objPermission.getPermissionRecipient() instanceof Role) {
                    recipientType = "ROLE";
                    recipientName = ((Role)objPermission.getPermissionRecipient()).getRoleName();
                    recipientTenantId = ((Role)objPermission.getPermissionRecipient()).getTenantId();
                }
                ObjectPermissionServiceImpl.this.auditContext.addPropertyToAuditEvent("recipientType", (Object)recipientType, auditEvent);
                ObjectPermissionServiceImpl.this.auditContext.addPropertyToAuditEvent("recipientName", (Object)recipientName, auditEvent);
                ObjectPermissionServiceImpl.this.auditContext.addPropertyToAuditEvent("recipientTenantId", (Object)recipientTenantId, auditEvent);
                if ("updatePermission".equals(auditEvent.getEventType())) {
                    ObjectPermissionServiceImpl.this.auditContext.addPropertyToAuditEvent("previousPermissionValue", (Object)previousPermissionValue, auditEvent);
                }
                ObjectPermissionServiceImpl.this.auditContext.addPropertyToAuditEvent("permissionValue", (Object)objPermission.getPermissionMask(), auditEvent);
            }
        });
    }

    public void putObjectPermission(ExecutionContext context, ObjectPermission objPermission) throws IllegalArgumentException {
        RepoObjectPermission existingPerm;
        boolean privileged;
        if (objPermission == null) {
            throw new IllegalArgumentException("Permission can't be null");
        }
        boolean bl = privileged = context != null && context.getAttributes() != null && context.getAttributes().contains("PRIVILEGED_OPERATION");
        if (!privileged && !this.isObjectAdministrable(context, objPermission.getURI())) {
            throw new AccessDeniedException("Access is denied");
        }
        Object permissionRecipient = objPermission.getPermissionRecipient();
        if (permissionRecipient == null) {
            throw new IllegalArgumentException("Permission recipient can't be null");
        }
        if (permissionRecipient instanceof User) {
            User user = (User)permissionRecipient;
            String username = user.getUsername();
            if (username == null || username.isEmpty()) {
                throw new IllegalArgumentException("User name can't be null");
            }
            HashSet<String> tenantSet = new HashSet<String>(1);
            tenantSet.add(user.getTenantId());
            List tenantUsers = this.userService.getTenantUsers(null, tenantSet, username);
            if (tenantUsers == null || tenantUsers.isEmpty()) {
                throw new IllegalArgumentException("User '" + username + "' doesn't exists and can't be used as permissionRecipient for permission");
            }
        } else if (permissionRecipient instanceof Role) {
            Role role = (Role)permissionRecipient;
            String roleName = role.getRoleName();
            if (roleName == null || roleName.isEmpty()) {
                throw new IllegalArgumentException("Role name can't be null");
            }
            HashSet<String> tenantSet = new HashSet<String>();
            tenantSet.add(role.getTenantId());
            List roles = this.userService.getTenantRoles(null, tenantSet, roleName);
            if (roles == null || roles.isEmpty()) {
                throw new IllegalArgumentException("Role '" + roleName + "' doesn't exists and can't be used as permissionRecipient for permission");
            }
        } else {
            throw new IllegalArgumentException("Unknown type of permissionRecipient. Invalid permissionRecipient: " + permissionRecipient.toString());
        }
        if ((existingPerm = this.getRepoObjectPermission(context, objPermission)) == null) {
            existingPerm = (RepoObjectPermission)this.getPersistentClassFactory().newObject(ObjectPermission.class);
        }
        this.addParamsToSetPermissionAuditEvent(context, objPermission, existingPerm.getPermissionMask());
        existingPerm.copyFromClient(objPermission, this);
        this.getHibernateTemplate().saveOrUpdate((Object)existingPerm);
        this.clearAclEntriesCache(objPermission.getURI());
    }

    public void deleteObjectPermission(ExecutionContext context, ObjectPermission objPermission) {
        RepoObjectPermission existingPerm = this.getRepoObjectPermission(context, objPermission);
        if (existingPerm == null) {
            throw new JSException("jsexception.no.such.object.permission");
        }
        this.addParamsToSetPermissionAuditEvent(context, objPermission, existingPerm.getPermissionMask());
        this.deleteObjectPermission(existingPerm);
    }

    protected void deleteObjectPermission(RepoObjectPermission permission) {
        this.deleteObjectPermission(permission, true);
    }

    protected void deleteObjectPermission(RepoObjectPermission permission, boolean checkAdministerAccess) {
        if (checkAdministerAccess && !this.isObjectAdministrable(null, permission.getURI())) {
            throw new AccessDeniedException("Access is denied");
        }
        this.getHibernateTemplate().delete((Object)permission);
        this.clearAclEntriesCache(permission.getURI());
    }

    public ObjectPermission getObjectPermission(ExecutionContext context, ObjectPermission objPermission) {
        RepoObjectPermission existingPerm = this.getRepoObjectPermission(context, objPermission);
        if (existingPerm == null) {
            return null;
        }
        return (ObjectPermission)existingPerm.toClient(this.getObjectMappingFactory());
    }

    private List getRepoObjectPermissions(ExecutionContext context, final String uri, Object recipient) {
        String queryString;
        final IdedObject recipientObject = (IdedObject)this.getPersistentObject(recipient);
        String objPermissionClassName = this.getPersistentClassFactory().getImplementationClassName(ObjectPermission.class);
        final Class recipientObjectClassName = recipient == null ? null : this.getPersistentClassFactory().getImplementationClass(recipient.getClass());
        List objList = null;
        if (uri == null && recipientObject == null) {
            queryString = "from " + objPermissionClassName;
            objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query query = session.createQuery(queryString);
                    return query.list();
                }
            });
        }
        if (uri != null && recipientObject != null) {
            queryString = "from " + objPermissionClassName + " as objPermission " + "where objPermission.URI = ? and " + "      objPermission.permissionRecipient.id = ? and objPermission.permissionRecipient.class = ?";
            objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query query = session.createQuery(queryString);
                    query.setParameter(0, (Object)uri, (Type)Hibernate.STRING);
                    query.setParameter(1, (Object)new Long(recipientObject.getId()), (Type)Hibernate.LONG);
                    query.setParameter(2, (Object)recipientObjectClassName, (Type)Hibernate.CLASS);
                    return query.list();
                }
            });
        } else if (uri != null) {
            queryString = "from " + objPermissionClassName + " as objPermission " + "where objPermission.URI = ?";
            objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query query = session.createQuery(queryString);
                    query.setParameter(0, (Object)uri, (Type)Hibernate.STRING);
                    return query.list();
                }
            });
        } else if (recipientObject != null) {
            ObjectPermissionRecipientIdentity recipientIdentity = new ObjectPermissionRecipientIdentity(recipientObject);
            objList = this.getRepoObjectPermissions(recipientIdentity);
        }
        return objList;
    }

    protected List getRepoObjectPermissions(final ObjectPermissionRecipientIdentity recipientIdentity) {
        String objPermissionClassName = this.getPersistentClassFactory().getImplementationClassName(ObjectPermission.class);
        final String queryString = "from " + objPermissionClassName + " as objPermission " + "where objPermission.permissionRecipient.id = ? and objPermission.permissionRecipient.class = ?";
        List objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(queryString);
                query.setParameter(0, (Object)new Long(recipientIdentity.getId()), (Type)Hibernate.LONG);
                query.setParameter(1, (Object)recipientIdentity.getRecipientClass(), (Type)Hibernate.CLASS);
                return query.list();
            }
        });
        return objList;
    }

    private List getRepoObjectPermissions(ExecutionContext context, ObjectPermission objPermission) {
        return this.getRepoObjectPermissions(context, objPermission.getURI(), objPermission.getPermissionRecipient());
    }

    private RepoObjectPermission getRepoObjectPermission(ExecutionContext context, ObjectPermission objPermission) {
        List objList = this.getRepoObjectPermissions(context, objPermission);
        RepoObjectPermission objPerm = null;
        if (objList == null || objList.isEmpty()) {
            log.debug((Object)("ObjectPermission not found with object \"" + objPermission.getURI() + "\", recipient \"" + objPermission.getPermissionRecipient() + "\""));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ObjectPermission FOUND with object \"" + objPermission.getURI() + "\", recipient \"" + objPermission.getPermissionRecipient() + "\""));
                log.debug((Object)("Size: " + objList.size()));
            }
            objPerm = (RepoObjectPermission)objList.get(0);
        }
        return objPerm;
    }

    public List getObjectPermissionsForObject(ExecutionContext context, Object targetObject) {
        if (targetObject == null || !(targetObject instanceof InternalURI)) {
            return new ArrayList();
        }
        InternalURI res = (InternalURI)targetObject;
        List objList = this.getRepoObjectPermissions(context, RESOURCE_URI_PREFIX + res.getPath(), null);
        return this.makeObjectPermissionClientList(RESOURCE_URI_PREFIX + res.getPath(), objList);
    }

    public List getObjectPermissionsForRecipient(ExecutionContext context, Object recipient) {
        List objList = this.getRepoObjectPermissions(context, null, recipient);
        return this.makeObjectPermissionClientList(null, objList);
    }

    public List getObjectPermissionsForObjectAndRecipient(ExecutionContext context, Object targetObject, Object recipient) {
        if (!(targetObject instanceof InternalURI)) {
            return new ArrayList();
        }
        InternalURI res = (InternalURI)targetObject;
        List objList = this.getRepoObjectPermissions(context, RESOURCE_URI_PREFIX + res.getPath(), recipient);
        return this.makeObjectPermissionClientList(RESOURCE_URI_PREFIX + res.getPath(), objList);
    }

    public boolean isObjectAdministrable(ExecutionContext context, Object targetObject) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (targetObject == null || auth == null) {
            return true;
        }
        BasicAclEntry[] allAcls = (BasicAclEntry[])this.effectiveAclsResolver.resolveEffectiveAcls(this.getAcls(targetObject), auth);
        if (allAcls != null) {
            for (int i = 0; i < allAcls.length; ++i) {
                BasicAclEntry aclEntry = allAcls[i];
                if (aclEntry.getMask() != SimpleAclEntry.ADMINISTRATION) continue;
                return true;
            }
        }
        return false;
    }

    private List makeObjectPermissionClientList(String uri, List objList) {
        ArrayList<ObjectPermission> resultList = new ArrayList<ObjectPermission>(objList.size());
        Iterator it = objList.iterator();
        while (!objList.isEmpty() && it.hasNext()) {
            RepoObjectPermission repoPerm = (RepoObjectPermission)it.next();
            ObjectPermission clientPermission = (ObjectPermission)repoPerm.toClient(this.getObjectMappingFactory());
            resultList.add(clientPermission);
        }
        return resultList;
    }

    @Override
    public Object getPersistentObject(Object clientObject) {
        if (clientObject == null) {
            return null;
        }
        if (clientObject instanceof IdedObject) {
            return clientObject;
        }
        if (clientObject instanceof Role || clientObject instanceof User) {
            return ((PersistentObjectResolver)this.userService).getPersistentObject(clientObject);
        }
        if (clientObject instanceof Resource) {
            String uri = ((Resource)clientObject).getPath();
            return this.repoService.findByURI(RepoResource.class, uri, false);
        }
        if (clientObject instanceof ObjectPermission) {
            return this.getRepoObjectPermission(null, (ObjectPermission)clientObject);
        }
        return null;
    }

    public RepoResource getExternalReference(String uri, Class persistentReferenceClass) {
        return ((ReferenceResolver)((Object)this.repoService)).getExternalReference(uri, persistentReferenceClass);
    }

    public RepoResource getReference(RepoResource owner, Resource resource, Class persistentReferenceClass) {
        return ((ReferenceResolver)((Object)this.repoService)).getReference(owner, resource, persistentReferenceClass);
    }

    protected String repositoryURI(String repositoryPath) {
        return RESOURCE_URI_PREFIX + repositoryPath;
    }

    protected void clearAclEntriesCache(String uri) {
        URIObjectIdentity objId = new URIObjectIdentity(uri);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing " + objId + " from permissions"));
        }
        this.basicAclEntryCache.removeEntriesFromCache((AclObjectIdentity)objId);
    }

    @Override
    public void updateObjectPermissionRepositoryPath(String oldPath, String newPath) {
        String oldURI = this.repositoryURI(oldPath);
        String newURI = this.repositoryURI(newPath);
        List permissions = this.getRepoObjectPermissions(null, oldURI, null);
        if (permissions != null && !permissions.isEmpty()) {
            for (RepoObjectPermission permission : permissions) {
                permission.setURI(newURI);
                this.getHibernateTemplate().update((Object)permission);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Updated URI of permission for " + oldURI + " and " + permission.getPermissionRecipient() + " to " + newURI));
            }
        }
        this.clearAclEntriesCache(oldURI);
    }

    public int getInheritedObjectPermissionMask(ExecutionContext context, Object targetObject, Object recipient) {
        if (!(targetObject instanceof InternalURI)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Requested inherited permission non InternalURI object " + targetObject));
            }
            return 0;
        }
        InternalURI resource = (InternalURI)targetObject;
        int permissionMask = 0;
        String folderURI = this.getParentURI(resource.getPath());
        while (folderURI != null) {
            List permissions = this.getRepoObjectPermissions(context, folderURI, recipient);
            if (permissions != null && !permissions.isEmpty()) {
                RepoObjectPermission permissionObject = (RepoObjectPermission)permissions.get(0);
                permissionMask = permissionObject.getPermissionMask();
                break;
            }
            folderURI = this.getParentURI(folderURI);
        }
        if (log.isDebugEnabled()) {
            if (folderURI == null) {
                log.debug((Object)("No inherited permission found for object " + resource.getPath() + " and recipient " + recipient));
            } else {
                log.debug((Object)("Inherited permission " + permissionMask + " found at " + folderURI + " for object " + resource.getPath() + " and recipient " + recipient));
            }
        }
        return permissionMask;
    }

    public static class URIObjectIdentity
    implements AclObjectIdentity {
        String uri;

        public URIObjectIdentity(String uri) {
            String fullUri = uri;
            if (uri != null && uri.startsWith("/")) {
                fullUri = ObjectPermissionServiceImpl.RESOURCE_URI_PREFIX + uri;
            }
            this.uri = fullUri;
        }

        public String getURI() {
            return this.uri;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("uri", (Object)this.getURI()).toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof URIObjectIdentity)) {
                return false;
            }
            URIObjectIdentity castOther = (URIObjectIdentity)other;
            return new EqualsBuilder().append((Object)this.getURI(), (Object)castOther.getURI()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getURI()).toHashCode();
        }
    }
}

