/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.domain.impl.hibernate;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.impl.hibernate.RepoOlapClientConnection;

public class RepoXMLAConnection
extends RepoOlapClientConnection
implements RepoReportDataSource {
    private String uri;
    private String dataSource;
    private String catalog;
    private String username;
    private String password;

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        XMLAConnection conn = (XMLAConnection)clientRes;
        conn.setCatalog(this.getCatalog());
        conn.setUsername(this.getUsername());
        conn.setPassword(PasswordCipherer.getInstance().decodePassword(this.getPassword()));
        conn.setDataSource(this.getDataSource());
        conn.setURI(this.getURI());
    }

    @Override
    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        XMLAConnection conn = (XMLAConnection)clientRes;
        this.setCatalog(conn.getCatalog());
        this.setUsername(conn.getUsername());
        this.setPassword(PasswordCipherer.getInstance().encodePassword(conn.getPassword()));
        this.setDataSource(conn.getDataSource());
        this.setURI(conn.getURI());
    }

    @Override
    protected Class getClientItf() {
        return XMLAConnection.class;
    }
}

