/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.data.snapshot.hibernate;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateSaveOrUpdateListener;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.RepoReportUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.SaveOrUpdateEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DataSnapshotReportUnitListener
implements HibernateDeleteListener,
HibernateSaveOrUpdateListener,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(DataSnapshotReportUnitListener.class);
    private ApplicationContext applicationContext;
    private String dataSnapshotServiceBean;

    @Override
    public void onDelete(Object o) {
        RepoReportUnit reportUnit;
        Long snapshotId;
        if (o instanceof RepoReportUnit && (snapshotId = (reportUnit = (RepoReportUnit)o).getDataSnapshotId()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleting snapshot " + snapshotId + " for report " + reportUnit.getResourceURI()));
            }
            this.dataSnapshotService().deleteSnapshot(snapshotId.longValue());
        }
    }

    @Override
    public void beforeSaveOrUpdate(SaveOrUpdateEvent event) {
    }

    @Override
    public void afterSaveOrUpdate(SaveOrUpdateEvent event) {
        Object entity = event.getEntity();
        EntityEntry entityEntry = event.getEntry();
        if (entity instanceof RepoReportUnit && entityEntry != null && entityEntry.isExistsInDatabase()) {
            RepoReportUnit reportUnit = (RepoReportUnit)entity;
            Long currentSnapshotId = reportUnit.getDataSnapshotId();
            Long oldSnapshotId = (Long)entityEntry.getLoadedValue("dataSnapshotId");
            if (!(oldSnapshotId == null || currentSnapshotId != null && oldSnapshotId.equals(currentSnapshotId))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("deleting snapshot " + currentSnapshotId + " for report " + reportUnit.getResourceURI() + ", replaced by " + currentSnapshotId));
                }
                this.dataSnapshotService().deleteSnapshot(oldSnapshotId.longValue());
            }
        }
    }

    protected DataSnapshotPersistenceService dataSnapshotService() {
        return (DataSnapshotPersistenceService)this.applicationContext.getBean(this.dataSnapshotServiceBean, DataSnapshotPersistenceService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getDataSnapshotServiceBean() {
        return this.dataSnapshotServiceBean;
    }

    public void setDataSnapshotServiceBean(String dataSnapshotServiceBean) {
        this.dataSnapshotServiceBean = dataSnapshotServiceBean;
    }
}

