/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileBufferedDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;

public class ContentRepoFileResource
extends RepoResource
implements InterceptFieldEnabled {
    private transient InterceptFieldCallback $CGLIB_READ_WRITE_CALLBACK;
    private static final Log log;
    private String fileType;
    private Blob data;

    @Override
    public InterceptFieldCallback getInterceptFieldCallback() {
        return this.$CGLIB_READ_WRITE_CALLBACK;
    }

    @Override
    public void setInterceptFieldCallback(InterceptFieldCallback interceptFieldCallback) {
        this.$CGLIB_READ_WRITE_CALLBACK = interceptFieldCallback;
    }

    public String $cglib_read_fileType() {
        String string = this.fileType;
        if (this.getInterceptFieldCallback() == null) {
            return string;
        }
        String string2 = string;
        return (String)this.getInterceptFieldCallback().readObject((Object)this, "fileType", (Object)string2);
    }

    public void $cglib_write_fileType(String string) {
        this.fileType = this.getInterceptFieldCallback() != null ? (String)this.getInterceptFieldCallback().writeObject((Object)this, "fileType", (Object)this.fileType, (Object)string) : string;
    }

    public Blob $cglib_read_data() {
        Blob blob = this.data;
        if (this.getInterceptFieldCallback() == null) {
            return blob;
        }
        Blob blob2 = blob;
        return (Blob)this.getInterceptFieldCallback().readObject((Object)this, "data", (Object)blob2);
    }

    public void $cglib_write_data(Blob blob) {
        this.data = this.getInterceptFieldCallback() != null ? (Blob)this.getInterceptFieldCallback().writeObject((Object)this, "data", (Object)this.data, (Object)blob) : blob;
    }

    public Blob getData() {
        return this.$cglib_read_data();
    }

    public void setData(Blob blob) {
        this.$cglib_write_data(blob);
    }

    public String getFileType() {
        return this.$cglib_read_fileType();
    }

    public void setFileType(String string) {
        this.$cglib_write_fileType(string);
    }

    protected void copyDataFrom(ContentResource contentResource) {
        if (contentResource.isReference()) {
            this.setData(null);
        } else if (contentResource.hasData()) {
            Blob blob;
            try {
                blob = Hibernate.createBlob((InputStream)contentResource.getDataStream());
            }
            catch (IOException iOException) {
                throw new JSException((Throwable)iOException);
            }
            this.setData(blob);
        }
    }

    public FileResourceData copyData() {
        FileResourceData fileResourceData;
        Blob blob = this.getData();
        if (blob == null) {
            fileResourceData = new FileResourceData((byte[])null);
        } else {
            DataContainer dataContainer = this.createDataContainer(blob);
            fileResourceData = new FileResourceData(dataContainer);
        }
        return fileResourceData;
    }

    @Override
    protected void copyTo(Resource resource, ResourceFactory resourceFactory) {
        super.copyTo(resource, resourceFactory);
        ContentResource contentResource = (ContentResource)resource;
        contentResource.setFileType(this.getFileType());
        if (this.hasClientOption("fullData")) {
            this.copyDataTo(contentResource);
        } else {
            contentResource.setDataContainer(null);
        }
        contentResource.setReferenceURI(null);
        RepoFolder repoFolder = this.getChildrenFolder();
        if (repoFolder != null) {
            Set set = repoFolder.getChildren();
            for (ContentRepoFileResource contentRepoFileResource : set) {
                contentResource.addChildResource((ContentResource)contentRepoFileResource.toClient(resourceFactory));
            }
        }
    }

    protected void copyDataTo(ContentResource contentResource) {
        Blob blob = this.getData();
        if (blob == null) {
            contentResource.setDataContainer(null);
        } else {
            DataContainer dataContainer = this.createDataContainer(blob);
            contentResource.setDataContainer(dataContainer);
        }
    }

    protected DataContainer createDataContainer(Blob blob) {
        try {
            InputStream inputStream = blob.getBinaryStream();
            FileBufferedDataContainer fileBufferedDataContainer = new FileBufferedDataContainer();
            fileBufferedDataContainer = DataContainerStreamUtil.pipeGzipSniffedData((InputStream)inputStream, (DataContainer)fileBufferedDataContainer);
            return fileBufferedDataContainer;
        }
        catch (SQLException sQLException) {
            log.error((Object)("Error while reading data blob of \"" + this.getResourceURI() + "\""), (Throwable)sQLException);
            throw new JSExceptionWrapper((Exception)sQLException);
        }
    }

    @Override
    protected void copyFrom(Resource resource, ReferenceResolver referenceResolver) {
        super.copyFrom(resource, referenceResolver);
        ContentResource contentResource = (ContentResource)resource;
        this.setFileType(contentResource.getFileType());
        this.copyDataFrom(contentResource);
        this.copyResources(referenceResolver, (ContentResource)resource);
    }

    private void copyResources(ReferenceResolver referenceResolver, ContentResource contentResource) {
        List list = contentResource.getResources();
        if (list != null && !list.isEmpty()) {
            for (ContentResource contentResource2 : list) {
                this.getReference((Resource)contentResource2, RepoFileResource.class, referenceResolver);
            }
        }
    }

    @Override
    protected Class getClientItf() {
        return ContentResource.class;
    }

    static {
        ContentRepoFileResource.CGLIB$STATICHOOK2();
        log = LogFactory.getLog(ContentRepoFileResource.class);
    }

    static void CGLIB$STATICHOOK2() {
    }
}

