/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.service.impl;

import com.jaspersoft.jasperserver.api.common.properties.Log4jPropertyChanger;
import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementService;
import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class LogSettingsDiagnosticService
implements Diagnostic {
    private Map<String, String> loggers = Collections.synchronizedMap(new LinkedHashMap());
    private PropertiesManagementService propertiesManagementService;
    private MessageSource messageSource;

    public void initLoggers(Map<String, String> loggers) {
        if (this.loggers.isEmpty()) {
            this.loggers.putAll(loggers);
        }
    }

    public void setPropertiesManagementService(PropertiesManagementService propertiesManagementService) {
        this.propertiesManagementService = propertiesManagementService;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("LogSettings", (DiagnosticCallback)new DiagnosticCallback<Map<String, String>>(){

            public Map<String, String> getDiagnosticAttributeValue() {
                for (Map.Entry entry : LogSettingsDiagnosticService.this.propertiesManagementService.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("log4j.")) continue;
                    LogSettingsDiagnosticService.this.loggers.put(Log4jPropertyChanger.parseKey((String)key), entry.getValue());
                }
                return LogSettingsDiagnosticService.this.generateLogSettingsWithDescription(LogSettingsDiagnosticService.this.loggers);
            }
        }).addDiagnosticAttribute("GlobalPropertiesList", (DiagnosticCallback)new DiagnosticCallback<Map<String, String>>(){

            public Map<String, String> getDiagnosticAttributeValue() {
                HashMap<String, String> globalPropertiesList = new HashMap<String, String>();
                for (Map.Entry entry : LogSettingsDiagnosticService.this.propertiesManagementService.entrySet()) {
                    globalPropertiesList.put((String)entry.getKey(), (String)entry.getValue());
                }
                return globalPropertiesList;
            }
        }).build();
    }

    private Map<String, String> generateLogSettingsWithDescription(Map<String, String> loggers) {
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, String> updatedLoggersWithDesc = new HashMap<String, String>();
        for (String loggerKey : loggers.keySet()) {
            String description = this.messageSource.getMessage(loggerKey, null, "", locale);
            description = description == null || description.isEmpty() ? "" : " (" + description + ")";
            updatedLoggersWithDesc.put(loggerKey, loggers.get(loggerKey) + description);
        }
        return updatedLoggersWithDesc;
    }
}

