/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.service.impl;

import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.OperatingSystemMXBeanWrapper;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.io.File;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalInfoCollectorService
implements Diagnostic {
    MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    OperatingSystemMXBeanWrapper osBean = new OperatingSystemMXBeanWrapper();
    RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
    ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
    List<GarbageCollectorMXBean> gcBean = ManagementFactory.getGarbageCollectorMXBeans();

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("AvailableLogicalProcessors", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                return Runtime.getRuntime().availableProcessors();
            }
        }).addDiagnosticAttribute("FreeMemory", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return Runtime.getRuntime().freeMemory();
            }
        }).addDiagnosticAttribute("MaxMemory", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return Runtime.getRuntime().maxMemory();
            }
        }).addDiagnosticAttribute("TotalMemory", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return Runtime.getRuntime().totalMemory();
            }
        }).addDiagnosticAttribute("Environment", (DiagnosticCallback)new DiagnosticCallback<Map<String, String>>(){

            public Map<String, String> getDiagnosticAttributeValue() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.putAll(System.getenv());
                return map;
            }
        }).addDiagnosticAttribute("Properties", (DiagnosticCallback)new DiagnosticCallback<Map<String, String>>(){

            public Map<String, String> getDiagnosticAttributeValue() {
                HashMap<String, String> result = new HashMap<String, String>();
                for (String prop : System.getProperties().stringPropertyNames()) {
                    result.put(prop, System.getProperty(prop));
                }
                return result;
            }
        }).addDiagnosticAttribute("JvmHeapMemory", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.memoryBean.getHeapMemoryUsage().toString();
            }
        }).addDiagnosticAttribute("JvmNonHeapMemory", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.memoryBean.getNonHeapMemoryUsage().toString();
            }
        }).addDiagnosticAttribute("OsName", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getName();
            }
        }).addDiagnosticAttribute("OsArchitecture", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getArch();
            }
        }).addDiagnosticAttribute("OsVersion", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getVersion();
            }
        }).addDiagnosticAttribute("OsSystemLoadAverage", (DiagnosticCallback)new DiagnosticCallback<Double>(){

            public Double getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getSystemLoadAverage();
            }
        }).addDiagnosticAttribute("OsTotalPhysicalMemorySize", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getTotalPhysicalMemorySize();
            }
        }).addDiagnosticAttribute("OsTotalSwapSpaceSize", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getTotalSwapSpaceSize();
            }
        }).addDiagnosticAttribute("OsFreeSwapSpaceSize", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getFreeSwapSpaceSize();
            }
        }).addDiagnosticAttribute("OsFreePhysicalMemorySize", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getFreePhysicalMemorySize();
            }
        }).addDiagnosticAttribute("OsProcessCpuTime", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getProcessCpuTime();
            }
        }).addDiagnosticAttribute("OsCommittedVirtualMemorySize", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.osBean.getCommittedVirtualMemorySize();
            }
        }).addDiagnosticAttribute("ClTotalLoadedClassCount", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.classLoadingBean.getTotalLoadedClassCount();
            }
        }).addDiagnosticAttribute("ClUnloadedClassCount", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.classLoadingBean.getUnloadedClassCount();
            }
        }).addDiagnosticAttribute("ClLoadedClassCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.classLoadingBean.getLoadedClassCount();
            }
        }).addDiagnosticAttribute("RtBootClassPath", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getBootClassPath();
            }
        }).addDiagnosticAttribute("RtClassPath", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getClassPath();
            }
        }).addDiagnosticAttribute("RtLibraryPath", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getLibraryPath();
            }
        }).addDiagnosticAttribute("RtUpTime", (DiagnosticCallback)new DiagnosticCallback<Long>(){

            public Long getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getUptime();
            }
        }).addDiagnosticAttribute("RtVmName", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getVmName();
            }
        }).addDiagnosticAttribute("RtVmVendor", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getVmVendor();
            }
        }).addDiagnosticAttribute("RtVmVersion", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getVmVersion();
            }
        }).addDiagnosticAttribute("RtInputArguments", (DiagnosticCallback)new DiagnosticCallback<String>(){

            public String getDiagnosticAttributeValue() {
                return ExternalInfoCollectorService.this.runtimeBean.getInputArguments().toString();
            }
        }).addDiagnosticAttribute("DisksFreeSpace", (DiagnosticCallback)new DiagnosticCallback<HashMap<String, Long>>(){

            public HashMap<String, Long> getDiagnosticAttributeValue() {
                File[] nodes = File.listRoots();
                HashMap<String, Long> result = new HashMap<String, Long>();
                for (File node : nodes) {
                    result.put(node.getName(), node.getFreeSpace());
                }
                return result;
            }
        }).build();
    }
}

