/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.access.service.impl;

import com.jaspersoft.jasperserver.api.logging.access.domain.AccessEvent;
import com.jaspersoft.jasperserver.api.logging.access.domain.AccessEventImpl;
import com.jaspersoft.jasperserver.api.logging.access.domain.hibernate.RepoAccessEvent;
import com.jaspersoft.jasperserver.api.logging.access.service.impl.AccessService;
import com.jaspersoft.jasperserver.api.logging.context.LoggableEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.impl.IdedObject;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class AccessServiceImpl
extends HibernateDaoImpl
implements AccessService,
PersistentObjectResolver {
    private HibernateRepositoryService hibernateRepositoryService;
    private PersistentObjectResolver persistentUserResolver;
    private int maxAccessEventAge;
    private ResourceFactory persistentClassFactory;
    private ResourceFactory clientClassFactory;
    public static final String COMMAND_OUT_LOGGER = "com.jaspersoft.jasperserver.export.command";

    public void setMaxAccessEventAge(int maxAccessEventAge) {
        this.maxAccessEventAge = maxAccessEventAge;
    }

    public void setHibernateRepositoryService(HibernateRepositoryService hibernateRepositoryService) {
        this.hibernateRepositoryService = hibernateRepositoryService;
    }

    public void setPersistentUserResolver(PersistentObjectResolver persistentUserResolver) {
        this.persistentUserResolver = persistentUserResolver;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    public void setClientClassFactory(ResourceFactory clientClassFactory) {
        this.clientClassFactory = clientClassFactory;
    }

    @Override
    public Object getPersistentObject(Object clientObject) {
        if (clientObject == null) {
            return null;
        }
        if (clientObject instanceof Resource) {
            return this.hibernateRepositoryService.getRepoResource((Resource)clientObject);
        }
        if (clientObject instanceof User) {
            return this.persistentUserResolver.getPersistentObject(clientObject);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void saveEvent(LoggableEvent loggableEvent) {
        AccessEvent accessEvent = (AccessEvent)loggableEvent;
        if (this.hibernateRepositoryService.resourceExists(null, accessEvent.getResource().getURI())) {
            RepoAccessEvent repoAccessEvent = new RepoAccessEvent();
            repoAccessEvent.copyFromClient(loggableEvent, this);
            this.getHibernateTemplate().save((Object)repoAccessEvent);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void saveEvents(List<LoggableEvent> loggableEvents) {
        if (loggableEvents == null || loggableEvents.isEmpty()) {
            return;
        }
        for (LoggableEvent loggableEvent : loggableEvents) {
            this.saveEvent(loggableEvent);
        }
    }

    @Override
    public List<AccessEvent> getAllEvents(int firstResult, int maxResults) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentClassFactory.getImplementationClass(AccessEvent.class));
        criteria.addOrder(Order.asc((String)"eventDate"));
        List results = this.getHibernateTemplate().findByCriteria(criteria, firstResult, maxResults);
        if (results != null && !results.isEmpty()) {
            ArrayList<AccessEvent> clientEventsList = new ArrayList<AccessEvent>(results.size());
            Log logger = LogFactory.getLog((String)COMMAND_OUT_LOGGER);
            for (Object event : results) {
                try {
                    AccessEvent accessEvent = (AccessEvent)((IdedObject)event).toClient(this.clientClassFactory);
                    clientEventsList.add(accessEvent);
                }
                catch (AccessEventImpl.TranslateException aex) {
                    logger.debug((Object)("Unable to translate access event:  resource = " + aex.getResource().getClass() + ", factory = " + aex.getResourceFactory().getClass()), (Throwable)aex.getOriginalException());
                }
                catch (Exception ex) {
                    logger.debug((Object)"Unable to translate access event", (Throwable)ex);
                }
            }
            return clientEventsList;
        }
        return Collections.emptyList();
    }

    @Override
    public int getAccessEventsCount() {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.persistentClassFactory.getImplementationClass(AccessEvent.class));
        criteria.setProjection(Projections.rowCount());
        return (Integer)this.getHibernateTemplate().findByCriteria(criteria).get(0);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=false)
    public void purgeAccessEvents() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -this.maxAccessEventAge);
        Date last = cal.getTime();
        this.getHibernateTemplate().bulkUpdate("delete RepoAccessEvent e where e.eventDate < ?", (Object)last);
    }
}

