/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;

class TranslatorRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    TranslatorRemove() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("remove");
        operation.get("description").set(bundle.getString("translator.remove"));
        return operation;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceName serviceName;
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String translatorName = pathAddress.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(serviceName = TeiidServiceNames.translatorServiceName(translatorName));
        if (controller != null) {
            context.removeService(serviceName);
        }
    }
}

