/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.teiid.jboss.Element;
import org.teiid.jboss.Namespace;

class TeiidSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    TeiidSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (!node.isDefined()) {
            return;
        }
        this.writeElement(writer, Element.ALLOW_ENV_FUNCTION_ELEMENT, node);
        this.writeElement(writer, Element.ASYNC_THREAD_POOL_ELEMENT, node);
        if (this.like(node, Element.BUFFER_SERVICE_ELEMENT)) {
            writer.writeStartElement(Element.BUFFER_SERVICE_ELEMENT.getLocalName());
            this.writeBufferService(writer, node);
            writer.writeEndElement();
        }
        this.writeElement(writer, Element.MAX_THREADS_ELEMENT, node);
        this.writeElement(writer, Element.MAX_ACTIVE_PLANS_ELEMENT, node);
        this.writeElement(writer, Element.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT, node);
        this.writeElement(writer, Element.TIME_SLICE_IN_MILLI_ELEMENT, node);
        this.writeElement(writer, Element.MAX_ROWS_FETCH_SIZE_ELEMENT, node);
        this.writeElement(writer, Element.LOB_CHUNK_SIZE_IN_KB_ELEMENT, node);
        this.writeElement(writer, Element.QUERY_THRESHOLD_IN_SECS_ELEMENT, node);
        this.writeElement(writer, Element.MAX_SOURCE_ROWS_ELEMENT, node);
        this.writeElement(writer, Element.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT, node);
        this.writeElement(writer, Element.DETECTING_CHANGE_EVENTS_ELEMENT, node);
        this.writeElement(writer, Element.QUERY_TIMEOUT, node);
        this.writeElement(writer, Element.WORKMANAGER, node);
        this.writeElement(writer, Element.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT, node);
        this.writeElement(writer, Element.POLICY_DECIDER_MODULE_ELEMENT, node);
        if (this.like(node, Element.RESULTSET_CACHE_ELEMENT)) {
            writer.writeStartElement(Element.RESULTSET_CACHE_ELEMENT.getLocalName());
            this.writeResultsetCacheConfiguration(writer, node);
            writer.writeEndElement();
        }
        if (this.like(node, Element.PREPAREDPLAN_CACHE_ELEMENT)) {
            writer.writeStartElement(Element.PREPAREDPLAN_CACHE_ELEMENT.getLocalName());
            this.writePreparedPlanCacheConfiguration(writer, node);
            writer.writeEndElement();
        }
        if (this.like(node, Element.DISTRIBUTED_CACHE)) {
            writer.writeStartElement(Element.DISTRIBUTED_CACHE.getLocalName());
            this.writeObjectReplicatorConfiguration(writer, node);
            writer.writeEndElement();
        }
        if (this.has(node, Element.TRANSPORT_ELEMENT.getLocalName())) {
            ArrayList transports = new ArrayList(node.get(Element.TRANSPORT_ELEMENT.getLocalName()).keys());
            Collections.sort(transports);
            if (!transports.isEmpty()) {
                for (String transport : transports) {
                    writer.writeStartElement(Element.TRANSPORT_ELEMENT.getLocalName());
                    this.writeTransportConfiguration(writer, node.get(new String[]{Element.TRANSPORT_ELEMENT.getLocalName(), transport}), transport);
                    writer.writeEndElement();
                }
            }
        }
        if (this.has(node, Element.TRANSLATOR_ELEMENT.getLocalName())) {
            ArrayList translators = new ArrayList(node.get(Element.TRANSLATOR_ELEMENT.getLocalName()).keys());
            Collections.sort(translators);
            if (!translators.isEmpty()) {
                for (String translator : translators) {
                    writer.writeStartElement(Element.TRANSLATOR_ELEMENT.getLocalName());
                    this.writeTranslator(writer, node.get(new String[]{Element.TRANSLATOR_ELEMENT.getLocalName(), translator}), translator);
                    writer.writeEndElement();
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeObjectReplicatorConfiguration(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeAttribute(writer, Element.DC_STACK_ATTRIBUTE, node);
    }

    private void writeTranslator(XMLExtendedStreamWriter writer, ModelNode node, String translatorName) throws XMLStreamException {
        writer.writeAttribute(Element.TRANSLATOR_NAME_ATTRIBUTE.getLocalName(), translatorName);
        this.writeAttribute(writer, Element.TRANSLATOR_MODULE_ATTRIBUTE, node);
    }

    private void writeTransportConfiguration(XMLExtendedStreamWriter writer, ModelNode node, String transportName) throws XMLStreamException {
        writer.writeAttribute(Element.TRANSPORT_NAME_ATTRIBUTE.getLocalName(), transportName);
        this.writeAttribute(writer, Element.TRANSPORT_SOCKET_BINDING_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.TRANSPORT_PROTOCOL_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE, node);
        if (this.like(node, Element.AUTHENTICATION_ELEMENT)) {
            writer.writeStartElement(Element.AUTHENTICATION_ELEMENT.getLocalName());
            this.writeAttribute(writer, Element.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, node);
            this.writeAttribute(writer, Element.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, node);
            this.writeAttribute(writer, Element.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, node);
            this.writeAttribute(writer, Element.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE, node);
            writer.writeEndElement();
        }
        if (this.like(node, Element.PG_ELEMENT)) {
            writer.writeStartElement(Element.PG_ELEMENT.getLocalName());
            this.writeAttribute(writer, Element.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT, node);
            writer.writeEndElement();
        }
        if (this.like(node, Element.SSL_ELEMENT)) {
            writer.writeStartElement(Element.SSL_ELEMENT.getLocalName());
            this.writeAttribute(writer, Element.SSL_MODE_ATTRIBUTE, node);
            this.writeAttribute(writer, Element.SSL_AUTH_MODE_ATTRIBUTE, node);
            this.writeAttribute(writer, Element.SSL_SSL_PROTOCOL_ATTRIBUTE, node);
            this.writeAttribute(writer, Element.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE, node);
            this.writeAttribute(writer, Element.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE, node);
            if (this.like(node, Element.SSL_KETSTORE_ELEMENT)) {
                writer.writeStartElement(Element.SSL_KETSTORE_ELEMENT.getLocalName());
                this.writeAttribute(writer, Element.SSL_KETSTORE_NAME_ATTRIBUTE, node);
                this.writeAttribute(writer, Element.SSL_KETSTORE_PASSWORD_ATTRIBUTE, node);
                this.writeAttribute(writer, Element.SSL_KETSTORE_TYPE_ATTRIBUTE, node);
                this.writeAttribute(writer, Element.SSL_KETSTORE_ALIAS_ATTRIBUTE, node);
                writer.writeEndElement();
            }
            if (this.like(node, Element.SSL_TRUSTSTORE_ELEMENT)) {
                writer.writeStartElement(Element.SSL_TRUSTSTORE_ELEMENT.getLocalName());
                this.writeAttribute(writer, Element.SSL_TRUSTSTORE_NAME_ATTRIBUTE, node);
                this.writeAttribute(writer, Element.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE, node);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeBufferService(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeAttribute(writer, Element.USE_DISK_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.INLINE_LOBS, node);
        this.writeAttribute(writer, Element.PROCESSOR_BATCH_SIZE_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.CONNECTOR_BATCH_SIZE_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MAX_PROCESSING_KB_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MAX_RESERVED_KB_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MAX_FILE_SIZE_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MAX_BUFFER_SPACE_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MAX_OPEN_FILES_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MEMORY_BUFFER_SPACE_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE, node);
    }

    private void writeResultsetCacheConfiguration(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeAttribute(writer, Element.RSC_NAME_ELEMENT, node);
        this.writeAttribute(writer, Element.RSC_CONTAINER_NAME_ELEMENT, node);
        this.writeAttribute(writer, Element.RSC_ENABLE_ATTRIBUTE, node);
        this.writeAttribute(writer, Element.RSC_MAX_STALENESS_ELEMENT, node);
    }

    private void writePreparedPlanCacheConfiguration(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        this.writeAttribute(writer, Element.PPC_NAME_ELEMENT, node);
        this.writeAttribute(writer, Element.PPC_CONTAINER_NAME_ELEMENT, node);
        this.writeAttribute(writer, Element.PPC_ENABLE_ATTRIBUTE, node);
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private boolean like(ModelNode node, Element element) {
        if (node.isDefined()) {
            Set keys = node.keys();
            for (String key : keys) {
                if (!key.startsWith(element.getLocalName())) continue;
                return true;
            }
        }
        return false;
    }

    private void writeElement(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String value;
        if (this.has(node, element.getModelName()) && !element.sameAsDefault(value = node.get(element.getModelName()).asString())) {
            writer.writeStartElement(element.getLocalName());
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String value;
        if (this.has(node, element.getModelName()) && !element.sameAsDefault(value = node.get(element.getModelName()).asString())) {
            writer.writeAttribute(element.getLocalName(), value);
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "teiid");
        address.protect();
        ModelNode bootServices = new ModelNode();
        bootServices.get("operation").set("add");
        bootServices.get("address").set(address);
        list.add(bootServices);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case TEIID_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALLOW_ENV_FUNCTION_ELEMENT: 
                        case EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT: 
                        case DETECTING_CHANGE_EVENTS_ELEMENT: {
                            bootServices.get(reader.getLocalName()).set(Boolean.parseBoolean(reader.getElementText()));
                            continue block15;
                        }
                        case POLICY_DECIDER_MODULE_ELEMENT: 
                        case AUTHORIZATION_VALIDATOR_MODULE_ELEMENT: 
                        case WORKMANAGER: {
                            bootServices.get(reader.getLocalName()).set(reader.getElementText());
                            continue block15;
                        }
                        case MAX_THREADS_ELEMENT: 
                        case MAX_ACTIVE_PLANS_ELEMENT: 
                        case USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT: 
                        case TIME_SLICE_IN_MILLI_ELEMENT: 
                        case MAX_ROWS_FETCH_SIZE_ELEMENT: 
                        case LOB_CHUNK_SIZE_IN_KB_ELEMENT: 
                        case QUERY_THRESHOLD_IN_SECS_ELEMENT: 
                        case MAX_SOURCE_ROWS_ELEMENT: 
                        case QUERY_TIMEOUT: {
                            bootServices.get(reader.getLocalName()).set(Integer.parseInt(reader.getElementText()));
                            continue block15;
                        }
                        case ASYNC_THREAD_POOL_ELEMENT: {
                            bootServices.get(reader.getLocalName()).set(reader.getElementText());
                            continue block15;
                        }
                        case DISTRIBUTED_CACHE: {
                            this.parseObjectReplicator(reader, bootServices);
                            continue block15;
                        }
                        case BUFFER_SERVICE_ELEMENT: {
                            this.parseBufferService(reader, bootServices);
                            continue block15;
                        }
                        case PREPAREDPLAN_CACHE_ELEMENT: {
                            this.parsePreparedPlanCacheConfiguration(reader, bootServices);
                            continue block15;
                        }
                        case RESULTSET_CACHE_ELEMENT: {
                            this.parseResultsetCacheConfiguration(reader, bootServices);
                            continue block15;
                        }
                        case TRANSPORT_ELEMENT: {
                            ModelNode transport = new ModelNode();
                            String name = this.parseTransport(reader, transport);
                            if (name != null) {
                                ModelNode transportAddress = address.clone();
                                transportAddress.add("transport", name);
                                transportAddress.protect();
                                transport.get("operation").set("add");
                                transport.get("address").set(transportAddress);
                                list.add(transport);
                                continue block15;
                            }
                            throw new XMLStreamException();
                        }
                        case TRANSLATOR_ELEMENT: {
                            ModelNode translatorNode = new ModelNode();
                            String translatorName = this.parseTranslator(reader, translatorNode);
                            if (translatorName != null) {
                                ModelNode translatorAddress = address.clone();
                                translatorAddress.add("translator", translatorName);
                                translatorAddress.protect();
                                translatorNode.get("operation").set("add");
                                translatorNode.get("address").set(translatorAddress);
                                list.add(translatorNode);
                                continue block15;
                            }
                            throw new XMLStreamException();
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseObjectReplicator(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.DISTRIBUTED_CACHE);
                switch (element) {
                    case DC_STACK_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private String parseTransport(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String transportName = null;
        if (reader.getAttributeCount() > 0) {
            block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName);
                switch (element) {
                    case TRANSPORT_NAME_ATTRIBUTE: 
                    case TRANSLATOR_NAME_ATTRIBUTE: {
                        transportName = attrValue;
                        continue block13;
                    }
                    case TRANSPORT_SOCKET_BINDING_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block13;
                    }
                    case TRANSPORT_PROTOCOL_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block13;
                    }
                    case TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block13;
                    }
                    case TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block13;
                    }
                    case TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION_ELEMENT: {
                    this.parseAuthentication(reader, node);
                    continue block14;
                }
                case PG_ELEMENT: {
                    this.parsePg(reader, node);
                    continue block14;
                }
                case SSL_ELEMENT: {
                    this.parseSSL(reader, node);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return transportName;
    }

    private ModelNode parseAuthentication(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.AUTHENTICATION_ELEMENT);
                switch (element) {
                    case AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block6;
                    }
                    case AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parsePg(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.PG_ELEMENT);
                switch (element) {
                    case PG_MAX_LOB_SIZE_ALLOWED_ELEMENT: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseSSL(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.SSL_ELEMENT);
                switch (element) {
                    case SSL_MODE_ATTRIBUTE: 
                    case SSL_AUTH_MODE_ATTRIBUTE: 
                    case SSL_SSL_PROTOCOL_ATTRIBUTE: 
                    case SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE: 
                    case SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SSL_KETSTORE_ELEMENT: {
                    this.parseKeystore(reader, node);
                    continue block8;
                }
                case SSL_TRUSTSTORE_ELEMENT: {
                    this.parseTruststore(reader, node);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return node;
    }

    private ModelNode parseKeystore(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.SSL_KETSTORE_ELEMENT);
                switch (element) {
                    case SSL_KETSTORE_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case SSL_KETSTORE_PASSWORD_ATTRIBUTE: {
                        node.get(element.getModelName()).setExpression(attrValue);
                        continue block6;
                    }
                    case SSL_KETSTORE_TYPE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case SSL_KETSTORE_ALIAS_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseTruststore(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.SSL_TRUSTSTORE_ELEMENT);
                switch (element) {
                    case SSL_TRUSTSTORE_NAME_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block4;
                    }
                    case SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE: {
                        node.get(element.getModelName()).setExpression(attrValue);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseBufferService(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.BUFFER_SERVICE_ELEMENT);
                switch (element) {
                    case USE_DISK_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block14;
                    }
                    case INLINE_LOBS: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block14;
                    }
                    case PROCESSOR_BATCH_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block14;
                    }
                    case CONNECTOR_BATCH_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block14;
                    }
                    case MAX_PROCESSING_KB_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block14;
                    }
                    case MAX_RESERVED_KB_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block14;
                    }
                    case MAX_OPEN_FILES_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block14;
                    }
                    case MAX_FILE_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Long.parseLong(attrValue));
                        continue block14;
                    }
                    case MAX_BUFFER_SPACE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Long.parseLong(attrValue));
                        continue block14;
                    }
                    case MEMORY_BUFFER_SPACE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block14;
                    }
                    case MEMORY_BUFFER_OFFHEAP_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block14;
                    }
                    case MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block14;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parsePreparedPlanCacheConfiguration(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.PREPAREDPLAN_CACHE_ELEMENT);
                switch (element) {
                    case PPC_CONTAINER_NAME_ELEMENT: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block5;
                    }
                    case PPC_ENABLE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block5;
                    }
                    case PPC_NAME_ELEMENT: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private ModelNode parseResultsetCacheConfiguration(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName, Element.RESULTSET_CACHE_ELEMENT);
                switch (element) {
                    case RSC_CONTAINER_NAME_ELEMENT: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    case RSC_ENABLE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(Boolean.parseBoolean(attrValue));
                        continue block6;
                    }
                    case RSC_MAX_STALENESS_ELEMENT: {
                        node.get(element.getModelName()).set(Integer.parseInt(attrValue));
                        continue block6;
                    }
                    case RSC_NAME_ELEMENT: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
        return node;
    }

    private String parseTranslator(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String translatorName = null;
        if (reader.getAttributeCount() > 0) {
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                Element element = Element.forName(attrName);
                switch (element) {
                    case TRANSPORT_NAME_ATTRIBUTE: 
                    case TRANSLATOR_NAME_ATTRIBUTE: {
                        translatorName = attrValue;
                        continue block4;
                    }
                    case TRANSLATOR_MODULE_ATTRIBUTE: {
                        node.get(element.getModelName()).set(attrValue);
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return translatorName;
    }
}

