/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.afterinvocation;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.Permission;
import org.springframework.security.afterinvocation.AbstractAclProvider;

public class AclEntryAfterInvocationProvider
extends AbstractAclProvider
implements MessageSourceAware {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$afterinvocation$AclEntryAfterInvocationProvider == null ? (class$org$springframework$security$afterinvocation$AclEntryAfterInvocationProvider = AclEntryAfterInvocationProvider.class$("org.springframework.security.afterinvocation.AclEntryAfterInvocationProvider")) : class$org$springframework$security$afterinvocation$AclEntryAfterInvocationProvider));
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    static /* synthetic */ Class class$org$springframework$security$afterinvocation$AclEntryAfterInvocationProvider;

    public AclEntryAfterInvocationProvider(AclService aclService, Permission[] requirePermission) {
        super(aclService, "AFTER_ACL_READ", requirePermission);
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        Iterator iter = config.getConfigAttributes().iterator();
        if (returnedObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Return object is null, skipping");
            }
            return null;
        }
        if (!this.getProcessDomainObjectClass().isAssignableFrom(returnedObject.getClass())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Return object is not applicable for this provider, skipping");
            }
            return returnedObject;
        }
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            if (this.hasPermission(authentication, returnedObject)) {
                return returnedObject;
            }
            logger.debug((Object)"Denying access");
            throw new AccessDeniedException(this.messages.getMessage("BasicAclEntryAfterInvocationProvider.noPermission", new Object[]{authentication.getName(), returnedObject}, "Authentication {0} has NO permissions to the domain object {1}"));
        }
        return returnedObject;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

