/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.sso;

import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalAuthProperties;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalUserDetails;
import com.jaspersoft.jasperserver.api.security.externalAuth.sso.AbstractSsoTicketValidator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SsoTicketValidatorImpl
extends AbstractSsoTicketValidator {
    private static final Logger logger = LogManager.getLogger(SsoTicketValidatorImpl.class);
    public static final String PRINCIPAL_XML_TAG_NAME = "principalXmlTagName";
    private String service;

    public ExternalUserDetails validate(Object ticket) throws AuthenticationServiceException {
        if (ticket == null || "".equals(ticket.toString().trim())) {
            throw new AuthenticationServiceException("No SSO token");
        }
        URI validationUrl = this.constructValidationUrl((String)ticket);
        ClientHttpResponse serverResponse = this.requestTicketValidationFromSsoServer(validationUrl);
        if (serverResponse == null) {
            throw new AuthenticationServiceException("The CAS server returned no response.");
        }
        return this.parseResponseFromServer(serverResponse);
    }

    protected URI constructValidationUrl(String ticket) throws AuthenticationServiceException {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        try {
            logger.debug((Object)("Constructing SSO token validation URL (ticket: " + ticket + ")"));
            ExternalAuthProperties externalAuthProperties = this.getExternalAuthProperties();
            String ticketParamName = externalAuthProperties.getTicketParameterName();
            urlParameters.put(ticketParamName, ticket);
            String serviceParameterName = externalAuthProperties.getServiceParameterName();
            if (serviceParameterName != null && serviceParameterName.length() > 0) {
                if (this.getService() != null && this.getService().length() > 0) {
                    urlParameters.put(serviceParameterName, this.getService());
                } else {
                    HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                    StringBuffer requestURL = req.getRequestURL();
                    urlParameters.put(serviceParameterName, requestURL.toString());
                }
            }
            URIBuilder uriBuilder = new URIBuilder(externalAuthProperties.getSsoServerTicketValidationUrl());
            for (Map.Entry param : urlParameters.entrySet()) {
                uriBuilder.setParameter((String)param.getKey(), (String)param.getValue());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Failed to construct the token validation URL (ticket: " + ticket + ")"), (Throwable)e);
            throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
        }
    }

    protected ClientHttpResponse requestTicketValidationFromSsoServer(URI validationUrl) throws AuthenticationServiceException {
        try {
            logger.debug((Object)("Requesting SSO token validation from SSO server: " + validationUrl));
            ClientHttpRequest req = this.getClientHttpRequestFactory().createRequest(validationUrl, HttpMethod.GET);
            ClientHttpResponse res = req.execute();
            return res;
        }
        catch (IOException e) {
            logger.error((Object)("Failed to validate SSO token (" + validationUrl + ")"), (Throwable)e);
            throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
        }
    }

    protected ExternalUserDetails parseResponseFromServer(ClientHttpResponse response) throws AuthenticationServiceException {
        logger.debug((Object)"Parsing response from SSO server");
        String principalNameFromSsoResponse = this.getPrincipalNameFromSsoResponse(response);
        return new ExternalUserDetails(principalNameFromSsoResponse);
    }

    protected String getPrincipalNameFromSsoResponse(ClientHttpResponse response) {
        try {
            DOMParser domParser = new DOMParser();
            domParser.parse(new InputSource(response.getBody()));
            String principalXmlTagName = this.getExternalAuthProperties().getCustomSsoProperty(PRINCIPAL_XML_TAG_NAME);
            NodeList nodeList = domParser.getDocument().getElementsByTagName(principalXmlTagName);
            if (nodeList == null || nodeList.getLength() == 0) {
                logger.warn((Object)"Could not find principal xml tag in the SSO server response.");
                throw new AuthenticationServiceException("SSO Authentication failed");
            }
            return nodeList.item(0).getTextContent();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get principal from the SSO server response", (Throwable)e);
            throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }
}

