/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.sso;

import com.jaspersoft.jasperserver.api.security.externalAuth.sso.SsoAuthenticationProcessingFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.rememberme.NullRememberMeServices;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.util.Assert;

public class SsoAuthenticationSoapProcessingFilter
extends SsoAuthenticationProcessingFilter {
    private String authorizationHeaderKeyName = "Authorization";
    private String encryptionKeyName = "Basic";
    private String credentialsDelimiter = ":";
    private String userName;
    private String password;
    private String ticket;
    private String service;
    private static final Logger logger = LogManager.getLogger(SsoAuthenticationSoapProcessingFilter.class);

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getAuthenticationManager(), (String)"authenticationManager must be specified");
        Assert.notNull((Object)this.getExternalDataSynchronizer(), (String)"externalDataSynchronizer cannot be null");
        Assert.notNull((Object)this.getExternalAuthProperties(), (String)"externalAuthProperties cannot be null");
        Assert.notNull((Object)this.getAuthorizationHeaderKeyName(), (String)"authorizationHeaderKeyName cannot be null");
        Assert.notNull((Object)this.getEncryptionKeyName(), (String)"encryptionKeyName cannot be null");
        Assert.notNull((Object)this.getCredentialsDelimiter(), (String)"credentialsDelimiter cannot be null");
        if (this.getRememberMeServices() == null) {
            this.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
        }
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresAuthentication(request, response)) {
            Authentication authResult;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Request is to process authentication");
            }
            try {
                this.onPreAuthentication(request, response);
                authResult = this.attemptAuthentication(request);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(request, response, failed);
                return;
            }
            this.successfulAuthentication(request, response, authResult);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String attToken = request.getHeader(this.authorizationHeaderKeyName);
        return attToken != null && attToken.startsWith(this.encryptionKeyName) || super.requiresAuthentication(request, response);
    }

    @Override
    protected Object obtainTicket(HttpServletRequest request) {
        return this.ticket;
    }

    protected String obtainUsername(HttpServletRequest request) {
        return this.userName;
    }

    protected String obtainPassword(HttpServletRequest request) {
        return this.password;
    }

    protected void onPreAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String base64Token;
        String token;
        int delim;
        String header = request.getHeader("Authorization");
        if (header != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header: " + header));
        }
        if (header != null && header.startsWith(this.encryptionKeyName) && (delim = (token = new String(Base64.decodeBase64((byte[])(base64Token = header.substring(6)).getBytes()))).indexOf(":")) != -1) {
            String tempHeader = token.substring(0, delim);
            if (tempHeader.equalsIgnoreCase(this.encryptionKeyName)) {
                this.ticket = token.substring(delim + 1);
            } else {
                this.userName = tempHeader;
                this.password = token.substring(delim + 1);
            }
        }
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) {
    }

    public String getAuthorizationHeaderKeyName() {
        return this.authorizationHeaderKeyName;
    }

    public void setAuthorizationHeaderKeyName(String authorizationHeaderKeyName) {
        this.authorizationHeaderKeyName = authorizationHeaderKeyName;
    }

    public String getEncryptionKeyName() {
        return this.encryptionKeyName;
    }

    public void setEncryptionKeyName(String encryptionKeyName) {
        this.encryptionKeyName = encryptionKeyName;
    }

    public String getCredentialsDelimiter() {
        return this.credentialsDelimiter;
    }

    public void setCredentialsDelimiter(String credentialsDelimiter) {
        this.credentialsDelimiter = credentialsDelimiter;
    }
}

