/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.sso;

import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalUserDetails;
import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalUserDetailsService;
import com.jaspersoft.jasperserver.api.security.externalAuth.sso.SsoAuthenticationToken;
import com.jaspersoft.jasperserver.api.security.externalAuth.sso.SsoTicketValidator;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.util.Assert;

public class SsoAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Logger logger = LogManager.getLogger(SsoAuthenticationProvider.class);
    private SsoTicketValidator ticketValidator;
    private ExternalUserDetailsService externalUserDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Object ssoToken = ((SsoAuthenticationToken)authentication).getTicket();
        logger.debug((Object)("Calling ticketValidator to authenticate token " + ssoToken));
        ExternalUserDetails userDetails = this.ticketValidator.validate(ssoToken);
        List authorities = this.externalUserDetailsService.loadAuthoritiesByUsername(userDetails.getUsername());
        userDetails.setAuthorities(authorities.toArray(new GrantedAuthority[authorities.size()]));
        return this.createSuccessAuthentication(authentication, userDetails, authorities);
    }

    protected Authentication createSuccessAuthentication(Authentication authentication, ExternalUserDetails userDetails, List<GrantedAuthority> authorities) {
        SsoAuthenticationToken ssoAuthenticationToken = new SsoAuthenticationToken(null, (Object)userDetails, null, authorities.toArray(new GrantedAuthority[authorities.size()]));
        ssoAuthenticationToken.setDetails(authentication.getDetails());
        return ssoAuthenticationToken;
    }

    public boolean supports(Class authentication) {
        boolean supportsSsoAuthToken = SsoAuthenticationToken.class.isAssignableFrom(authentication);
        logger.debug((Object)("Provider " + (supportsSsoAuthToken ? "supports" : "does not support") + " authentication with " + authentication.getName()));
        return supportsSsoAuthToken;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ticketValidator, (String)"ticketValidator must not be null in SsoAuthenticationProvider.");
    }

    public void setTicketValidator(SsoTicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public ExternalUserDetailsService getExternalUserDetailsService() {
        return this.externalUserDetailsService;
    }

    public void setExternalUserDetailsService(ExternalUserDetailsService externalUserDetailsService) {
        this.externalUserDetailsService = externalUserDetailsService;
    }
}

