/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.custom;

import com.jaspersoft.jasperserver.api.security.externalAuth.custom.CustomAuthenticationToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;

public class CustomAuthenticationProvider
implements AuthenticationProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        this.logger.trace((Object)("user " + ((UserDetails)authentication.getPrincipal()).getUsername() + " has an even user name length"));
        return this.createSuccessAuthentication(authentication, (UserDetails)authentication.getPrincipal());
    }

    protected Authentication createSuccessAuthentication(Authentication authentication, UserDetails userDetails) {
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), userDetails.getAuthorities());
        authToken.setDetails((Object)userDetails);
        return authToken;
    }

    public boolean supports(Class authentication) {
        boolean supportsCustomToken = CustomAuthenticationToken.class.isAssignableFrom(authentication);
        this.logger.debug((Object)("Provider " + (supportsCustomToken ? "supports" : "does not support") + " authentication with " + authentication.getName()));
        return supportsCustomToken;
    }
}

